/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteQueueRequestMarshaller
implements Marshaller<Request<DeleteQueueRequest>, DeleteQueueRequest> {
    @Override
    public Request<DeleteQueueRequest> marshall(DeleteQueueRequest deleteQueueRequest) {
        if (deleteQueueRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteQueueRequest> request = new DefaultRequest<DeleteQueueRequest>(deleteQueueRequest, "AmazonSQS");
        request.addParameter("Action", "DeleteQueue");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteQueueRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(deleteQueueRequest.getQueueUrl()));
        }
        return request;
    }
}

