/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroupstaggingapi.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.resourcegroupstaggingapi.model.ResourceTagMapping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetResourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String paginationToken;
    private List<ResourceTagMapping> resourceTagMappingList;

    public void setPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
    }

    public String getPaginationToken() {
        return this.paginationToken;
    }

    public GetResourcesResult withPaginationToken(String paginationToken) {
        this.setPaginationToken(paginationToken);
        return this;
    }

    public List<ResourceTagMapping> getResourceTagMappingList() {
        return this.resourceTagMappingList;
    }

    public void setResourceTagMappingList(Collection<ResourceTagMapping> resourceTagMappingList) {
        if (resourceTagMappingList == null) {
            this.resourceTagMappingList = null;
            return;
        }
        this.resourceTagMappingList = new ArrayList<ResourceTagMapping>(resourceTagMappingList);
    }

    public GetResourcesResult withResourceTagMappingList(ResourceTagMapping ... resourceTagMappingList) {
        if (this.resourceTagMappingList == null) {
            this.setResourceTagMappingList(new ArrayList<ResourceTagMapping>(resourceTagMappingList.length));
        }
        for (ResourceTagMapping ele : resourceTagMappingList) {
            this.resourceTagMappingList.add(ele);
        }
        return this;
    }

    public GetResourcesResult withResourceTagMappingList(Collection<ResourceTagMapping> resourceTagMappingList) {
        this.setResourceTagMappingList(resourceTagMappingList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPaginationToken() != null) {
            sb.append("PaginationToken: ").append(this.getPaginationToken()).append(",");
        }
        if (this.getResourceTagMappingList() != null) {
            sb.append("ResourceTagMappingList: ").append(this.getResourceTagMappingList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesResult)) {
            return false;
        }
        GetResourcesResult other = (GetResourcesResult)obj;
        if (other.getPaginationToken() == null ^ this.getPaginationToken() == null) {
            return false;
        }
        if (other.getPaginationToken() != null && !other.getPaginationToken().equals(this.getPaginationToken())) {
            return false;
        }
        if (other.getResourceTagMappingList() == null ^ this.getResourceTagMappingList() == null) {
            return false;
        }
        return other.getResourceTagMappingList() == null || other.getResourceTagMappingList().equals(this.getResourceTagMappingList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPaginationToken() == null ? 0 : this.getPaginationToken().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTagMappingList() == null ? 0 : this.getResourceTagMappingList().hashCode());
        return hashCode;
    }

    public GetResourcesResult clone() {
        try {
            return (GetResourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

