/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecs.model.VersionInfo;

@SdkInternalApi
public class VersionInfoMarshaller {
    private static final MarshallingInfo<String> AGENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("agentVersion").build();
    private static final MarshallingInfo<String> AGENTHASH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("agentHash").build();
    private static final MarshallingInfo<String> DOCKERVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dockerVersion").build();
    private static final VersionInfoMarshaller instance = new VersionInfoMarshaller();

    public static VersionInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(VersionInfo versionInfo, ProtocolMarshaller protocolMarshaller) {
        if (versionInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(versionInfo.getAgentVersion(), AGENTVERSION_BINDING);
            protocolMarshaller.marshall(versionInfo.getAgentHash(), AGENTHASH_BINDING);
            protocolMarshaller.marshall(versionInfo.getDockerVersion(), DOCKERVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

