/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.services.snowball.model.S3Resource;
import com.amazonaws.services.snowball.model.transform.KeyRangeJsonUnmarshaller;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class S3ResourceJsonUnmarshaller
implements Unmarshaller<S3Resource, JsonUnmarshallerContext> {
    private static S3ResourceJsonUnmarshaller instance;

    @Override
    public S3Resource unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Resource s3Resource = new S3Resource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BucketArn", targetDepth)) {
                    context.nextToken();
                    s3Resource.setBucketArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("KeyRange", targetDepth)) {
                    context.nextToken();
                    s3Resource.setKeyRange(KeyRangeJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Resource;
    }

    public static S3ResourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3ResourceJsonUnmarshaller();
        }
        return instance;
    }
}

