/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dynamodbv2.model.Identity;
import com.amazonaws.services.dynamodbv2.model.OperationType;
import com.amazonaws.services.dynamodbv2.model.StreamRecord;
import com.amazonaws.services.dynamodbv2.model.transform.RecordMarshaller;
import java.io.Serializable;

public class Record
implements Serializable,
Cloneable,
StructuredPojo {
    private String eventID;
    private String eventName;
    private String eventVersion;
    private String eventSource;
    private String awsRegion;
    private StreamRecord dynamodb;
    private Identity userIdentity;

    public void setEventID(String eventID) {
        this.eventID = eventID;
    }

    public String getEventID() {
        return this.eventID;
    }

    public Record withEventID(String eventID) {
        this.setEventID(eventID);
        return this;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public Record withEventName(String eventName) {
        this.setEventName(eventName);
        return this;
    }

    public void setEventName(OperationType eventName) {
        this.eventName = eventName.toString();
    }

    public Record withEventName(OperationType eventName) {
        this.setEventName(eventName);
        return this;
    }

    public void setEventVersion(String eventVersion) {
        this.eventVersion = eventVersion;
    }

    public String getEventVersion() {
        return this.eventVersion;
    }

    public Record withEventVersion(String eventVersion) {
        this.setEventVersion(eventVersion);
        return this;
    }

    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    public String getEventSource() {
        return this.eventSource;
    }

    public Record withEventSource(String eventSource) {
        this.setEventSource(eventSource);
        return this;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public Record withAwsRegion(String awsRegion) {
        this.setAwsRegion(awsRegion);
        return this;
    }

    public void setDynamodb(StreamRecord dynamodb) {
        this.dynamodb = dynamodb;
    }

    public StreamRecord getDynamodb() {
        return this.dynamodb;
    }

    public Record withDynamodb(StreamRecord dynamodb) {
        this.setDynamodb(dynamodb);
        return this;
    }

    public void setUserIdentity(Identity userIdentity) {
        this.userIdentity = userIdentity;
    }

    public Identity getUserIdentity() {
        return this.userIdentity;
    }

    public Record withUserIdentity(Identity userIdentity) {
        this.setUserIdentity(userIdentity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventID() != null) {
            sb.append("EventID: ").append(this.getEventID()).append(",");
        }
        if (this.getEventName() != null) {
            sb.append("EventName: ").append(this.getEventName()).append(",");
        }
        if (this.getEventVersion() != null) {
            sb.append("EventVersion: ").append(this.getEventVersion()).append(",");
        }
        if (this.getEventSource() != null) {
            sb.append("EventSource: ").append(this.getEventSource()).append(",");
        }
        if (this.getAwsRegion() != null) {
            sb.append("AwsRegion: ").append(this.getAwsRegion()).append(",");
        }
        if (this.getDynamodb() != null) {
            sb.append("Dynamodb: ").append(this.getDynamodb()).append(",");
        }
        if (this.getUserIdentity() != null) {
            sb.append("UserIdentity: ").append(this.getUserIdentity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        if (other.getEventID() == null ^ this.getEventID() == null) {
            return false;
        }
        if (other.getEventID() != null && !other.getEventID().equals(this.getEventID())) {
            return false;
        }
        if (other.getEventName() == null ^ this.getEventName() == null) {
            return false;
        }
        if (other.getEventName() != null && !other.getEventName().equals(this.getEventName())) {
            return false;
        }
        if (other.getEventVersion() == null ^ this.getEventVersion() == null) {
            return false;
        }
        if (other.getEventVersion() != null && !other.getEventVersion().equals(this.getEventVersion())) {
            return false;
        }
        if (other.getEventSource() == null ^ this.getEventSource() == null) {
            return false;
        }
        if (other.getEventSource() != null && !other.getEventSource().equals(this.getEventSource())) {
            return false;
        }
        if (other.getAwsRegion() == null ^ this.getAwsRegion() == null) {
            return false;
        }
        if (other.getAwsRegion() != null && !other.getAwsRegion().equals(this.getAwsRegion())) {
            return false;
        }
        if (other.getDynamodb() == null ^ this.getDynamodb() == null) {
            return false;
        }
        if (other.getDynamodb() != null && !other.getDynamodb().equals(this.getDynamodb())) {
            return false;
        }
        if (other.getUserIdentity() == null ^ this.getUserIdentity() == null) {
            return false;
        }
        return other.getUserIdentity() == null || other.getUserIdentity().equals(this.getUserIdentity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventID() == null ? 0 : this.getEventID().hashCode());
        hashCode = 31 * hashCode + (this.getEventName() == null ? 0 : this.getEventName().hashCode());
        hashCode = 31 * hashCode + (this.getEventVersion() == null ? 0 : this.getEventVersion().hashCode());
        hashCode = 31 * hashCode + (this.getEventSource() == null ? 0 : this.getEventSource().hashCode());
        hashCode = 31 * hashCode + (this.getAwsRegion() == null ? 0 : this.getAwsRegion().hashCode());
        hashCode = 31 * hashCode + (this.getDynamodb() == null ? 0 : this.getDynamodb().hashCode());
        hashCode = 31 * hashCode + (this.getUserIdentity() == null ? 0 : this.getUserIdentity().hashCode());
        return hashCode;
    }

    public Record clone() {
        try {
            return (Record)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

