/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.SuspendProcessesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SuspendProcessesRequestMarshaller
implements Marshaller<Request<SuspendProcessesRequest>, SuspendProcessesRequest> {
    @Override
    public Request<SuspendProcessesRequest> marshall(SuspendProcessesRequest suspendProcessesRequest) {
        SdkInternalList scalingProcessesList;
        if (suspendProcessesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SuspendProcessesRequest> request = new DefaultRequest<SuspendProcessesRequest>(suspendProcessesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "SuspendProcesses");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (suspendProcessesRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(suspendProcessesRequest.getAutoScalingGroupName()));
        }
        if (!(scalingProcessesList = (SdkInternalList)suspendProcessesRequest.getScalingProcesses()).isEmpty() || !scalingProcessesList.isAutoConstruct()) {
            int scalingProcessesListIndex = 1;
            for (String scalingProcessesListValue : scalingProcessesList) {
                if (scalingProcessesListValue != null) {
                    request.addParameter("ScalingProcesses.member." + scalingProcessesListIndex, StringUtils.fromString(scalingProcessesListValue));
                }
                ++scalingProcessesListIndex;
            }
        }
        return request;
    }
}

