/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.worklink.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateWebsiteAuthorizationProvider"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AssociateWebsiteAuthorizationProviderRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The ARN of the fleet.
     * </p>
     */
    private String fleetArn;
    /**
     * <p>
     * The authorization provider type.
     * </p>
     */
    private String authorizationProviderType;
    /**
     * <p>
     * The domain name of the authorization provider. This applies only to SAML-based authorization providers.
     * </p>
     */
    private String domainName;

    /**
     * <p>
     * The ARN of the fleet.
     * </p>
     * 
     * @param fleetArn
     *        The ARN of the fleet.
     */

    public void setFleetArn(String fleetArn) {
        this.fleetArn = fleetArn;
    }

    /**
     * <p>
     * The ARN of the fleet.
     * </p>
     * 
     * @return The ARN of the fleet.
     */

    public String getFleetArn() {
        return this.fleetArn;
    }

    /**
     * <p>
     * The ARN of the fleet.
     * </p>
     * 
     * @param fleetArn
     *        The ARN of the fleet.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AssociateWebsiteAuthorizationProviderRequest withFleetArn(String fleetArn) {
        setFleetArn(fleetArn);
        return this;
    }

    /**
     * <p>
     * The authorization provider type.
     * </p>
     * 
     * @param authorizationProviderType
     *        The authorization provider type.
     * @see AuthorizationProviderType
     */

    public void setAuthorizationProviderType(String authorizationProviderType) {
        this.authorizationProviderType = authorizationProviderType;
    }

    /**
     * <p>
     * The authorization provider type.
     * </p>
     * 
     * @return The authorization provider type.
     * @see AuthorizationProviderType
     */

    public String getAuthorizationProviderType() {
        return this.authorizationProviderType;
    }

    /**
     * <p>
     * The authorization provider type.
     * </p>
     * 
     * @param authorizationProviderType
     *        The authorization provider type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AuthorizationProviderType
     */

    public AssociateWebsiteAuthorizationProviderRequest withAuthorizationProviderType(String authorizationProviderType) {
        setAuthorizationProviderType(authorizationProviderType);
        return this;
    }

    /**
     * <p>
     * The authorization provider type.
     * </p>
     * 
     * @param authorizationProviderType
     *        The authorization provider type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AuthorizationProviderType
     */

    public AssociateWebsiteAuthorizationProviderRequest withAuthorizationProviderType(AuthorizationProviderType authorizationProviderType) {
        this.authorizationProviderType = authorizationProviderType.toString();
        return this;
    }

    /**
     * <p>
     * The domain name of the authorization provider. This applies only to SAML-based authorization providers.
     * </p>
     * 
     * @param domainName
     *        The domain name of the authorization provider. This applies only to SAML-based authorization providers.
     */

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    /**
     * <p>
     * The domain name of the authorization provider. This applies only to SAML-based authorization providers.
     * </p>
     * 
     * @return The domain name of the authorization provider. This applies only to SAML-based authorization providers.
     */

    public String getDomainName() {
        return this.domainName;
    }

    /**
     * <p>
     * The domain name of the authorization provider. This applies only to SAML-based authorization providers.
     * </p>
     * 
     * @param domainName
     *        The domain name of the authorization provider. This applies only to SAML-based authorization providers.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AssociateWebsiteAuthorizationProviderRequest withDomainName(String domainName) {
        setDomainName(domainName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getFleetArn() != null)
            sb.append("FleetArn: ").append(getFleetArn()).append(",");
        if (getAuthorizationProviderType() != null)
            sb.append("AuthorizationProviderType: ").append(getAuthorizationProviderType()).append(",");
        if (getDomainName() != null)
            sb.append("DomainName: ").append(getDomainName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AssociateWebsiteAuthorizationProviderRequest == false)
            return false;
        AssociateWebsiteAuthorizationProviderRequest other = (AssociateWebsiteAuthorizationProviderRequest) obj;
        if (other.getFleetArn() == null ^ this.getFleetArn() == null)
            return false;
        if (other.getFleetArn() != null && other.getFleetArn().equals(this.getFleetArn()) == false)
            return false;
        if (other.getAuthorizationProviderType() == null ^ this.getAuthorizationProviderType() == null)
            return false;
        if (other.getAuthorizationProviderType() != null && other.getAuthorizationProviderType().equals(this.getAuthorizationProviderType()) == false)
            return false;
        if (other.getDomainName() == null ^ this.getDomainName() == null)
            return false;
        if (other.getDomainName() != null && other.getDomainName().equals(this.getDomainName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getFleetArn() == null) ? 0 : getFleetArn().hashCode());
        hashCode = prime * hashCode + ((getAuthorizationProviderType() == null) ? 0 : getAuthorizationProviderType().hashCode());
        hashCode = prime * hashCode + ((getDomainName() == null) ? 0 : getDomainName().hashCode());
        return hashCode;
    }

    @Override
    public AssociateWebsiteAuthorizationProviderRequest clone() {
        return (AssociateWebsiteAuthorizationProviderRequest) super.clone();
    }

}
