/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.importexport.AmazonImportExport;
import com.amazonaws.services.importexport.AmazonImportExportClientBuilder;
import com.amazonaws.services.importexport.model.AmazonImportExportException;
import com.amazonaws.services.importexport.model.CancelJobRequest;
import com.amazonaws.services.importexport.model.CancelJobResult;
import com.amazonaws.services.importexport.model.CreateJobRequest;
import com.amazonaws.services.importexport.model.CreateJobResult;
import com.amazonaws.services.importexport.model.GetShippingLabelRequest;
import com.amazonaws.services.importexport.model.GetShippingLabelResult;
import com.amazonaws.services.importexport.model.GetStatusRequest;
import com.amazonaws.services.importexport.model.GetStatusResult;
import com.amazonaws.services.importexport.model.ListJobsRequest;
import com.amazonaws.services.importexport.model.ListJobsResult;
import com.amazonaws.services.importexport.model.UpdateJobRequest;
import com.amazonaws.services.importexport.model.UpdateJobResult;
import com.amazonaws.services.importexport.model.transform.BucketPermissionExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.CancelJobRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.CancelJobResultStaxUnmarshaller;
import com.amazonaws.services.importexport.model.transform.CanceledJobIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.CreateJobQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.CreateJobRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.CreateJobResultStaxUnmarshaller;
import com.amazonaws.services.importexport.model.transform.ExpiredJobIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.GetShippingLabelRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.GetShippingLabelResultStaxUnmarshaller;
import com.amazonaws.services.importexport.model.transform.GetStatusRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.GetStatusResultStaxUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidAccessKeyIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidAddressExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidCustomsExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidFileSystemExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidJobIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidManifestFieldExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidVersionExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.ListJobsRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.ListJobsResultStaxUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MalformedManifestExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MissingCustomsExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MissingManifestFieldExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MissingParameterExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MultipleRegionsExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.NoSuchBucketExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.UnableToCancelJobIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.UnableToUpdateJobIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.UpdateJobRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.UpdateJobResultStaxUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

@ThreadSafe
public class AmazonImportExportClient
extends AmazonWebServiceClient
implements AmazonImportExport {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonImportExport.class);
    private static final String DEFAULT_SIGNING_NAME = "importexport";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    @Deprecated
    public AmazonImportExportClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonImportExportClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonImportExportClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonImportExportClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AmazonImportExportClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonImportExportClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonImportExportClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AmazonImportExportClientBuilder builder() {
        return AmazonImportExportClientBuilder.standard();
    }

    AmazonImportExportClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new MissingCustomsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidVersionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MultipleRegionsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CreateJobQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new UnableToUpdateJobIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchBucketExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new BucketPermissionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidCustomsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new UnableToCancelJobIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CanceledJobIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ExpiredJobIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidJobIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidManifestFieldExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingManifestFieldExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MalformedManifestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidAccessKeyIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidAddressExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidFileSystemExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller(AmazonImportExportException.class));
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://importexport.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/importexport/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/importexport/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelJobResult cancelJob(CancelJobRequest cancelJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelJobRequestMarshaller().marshall(super.beforeMarshalling(cancelJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<CancelJobResult> responseHandler = new StaxResponseHandler<CancelJobResult>(new CancelJobResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelJobResult cancelJobResult = (CancelJobResult)response.getAwsResponse();
            return cancelJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobResult createJob(CreateJobRequest createJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateJobRequestMarshaller().marshall(super.beforeMarshalling(createJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<CreateJobResult> responseHandler = new StaxResponseHandler<CreateJobResult>(new CreateJobResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateJobResult createJobResult = (CreateJobResult)response.getAwsResponse();
            return createJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetShippingLabelResult getShippingLabel(GetShippingLabelRequest getShippingLabelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getShippingLabelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetShippingLabelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetShippingLabelRequestMarshaller().marshall(super.beforeMarshalling(getShippingLabelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<GetShippingLabelResult> responseHandler = new StaxResponseHandler<GetShippingLabelResult>(new GetShippingLabelResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetShippingLabelResult getShippingLabelResult = (GetShippingLabelResult)response.getAwsResponse();
            return getShippingLabelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStatusResult getStatus(GetStatusRequest getStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetStatusRequestMarshaller().marshall(super.beforeMarshalling(getStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<GetStatusResult> responseHandler = new StaxResponseHandler<GetStatusResult>(new GetStatusResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetStatusResult getStatusResult = (GetStatusResult)response.getAwsResponse();
            return getStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResult listJobs(ListJobsRequest listJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsRequestMarshaller().marshall(super.beforeMarshalling(listJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<ListJobsResult> responseHandler = new StaxResponseHandler<ListJobsResult>(new ListJobsResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListJobsResult listJobsResult = (ListJobsResult)response.getAwsResponse();
            return listJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListJobsResult listJobs() {
        return this.listJobs(new ListJobsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobResult updateJob(UpdateJobRequest updateJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateJobRequestMarshaller().marshall(super.beforeMarshalling(updateJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<UpdateJobResult> responseHandler = new StaxResponseHandler<UpdateJobResult>(new UpdateJobResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateJobResult updateJobResult = (UpdateJobResult)response.getAwsResponse();
            return updateJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

