/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glacier.model.ListPartsRequest;
import com.amazonaws.services.glacier.model.transform.DefaultAccountIdSupplier;

@SdkInternalApi
public class ListPartsRequestMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").build();
    private static final MarshallingInfo<String> UPLOADID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("uploadId").build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("marker").build();
    private static final MarshallingInfo<String> LIMIT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("limit").build();
    private static final ListPartsRequestMarshaller instance = new ListPartsRequestMarshaller();

    public static ListPartsRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(ListPartsRequest listPartsRequest, ProtocolMarshaller protocolMarshaller) {
        if (listPartsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(listPartsRequest.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall(listPartsRequest.getVaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall(listPartsRequest.getUploadId(), UPLOADID_BINDING);
            protocolMarshaller.marshall(listPartsRequest.getMarker(), MARKER_BINDING);
            protocolMarshaller.marshall(listPartsRequest.getLimit(), LIMIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

