/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.RunScheduledInstancesRequest;
import com.amazonaws.services.ec2.model.ScheduledInstancesBlockDeviceMapping;
import com.amazonaws.services.ec2.model.ScheduledInstancesEbs;
import com.amazonaws.services.ec2.model.ScheduledInstancesIamInstanceProfile;
import com.amazonaws.services.ec2.model.ScheduledInstancesIpv6Address;
import com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification;
import com.amazonaws.services.ec2.model.ScheduledInstancesMonitoring;
import com.amazonaws.services.ec2.model.ScheduledInstancesNetworkInterface;
import com.amazonaws.services.ec2.model.ScheduledInstancesPlacement;
import com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class RunScheduledInstancesRequestMarshaller
implements Marshaller<Request<RunScheduledInstancesRequest>, RunScheduledInstancesRequest> {
    @Override
    public Request<RunScheduledInstancesRequest> marshall(RunScheduledInstancesRequest runScheduledInstancesRequest) {
        ScheduledInstancesLaunchSpecification launchSpecification;
        if (runScheduledInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RunScheduledInstancesRequest> request = new DefaultRequest<RunScheduledInstancesRequest>(runScheduledInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RunScheduledInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        request.addParameter("ClientToken", IdempotentUtils.resolveString(runScheduledInstancesRequest.getClientToken()));
        if (runScheduledInstancesRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger(runScheduledInstancesRequest.getInstanceCount()));
        }
        if (runScheduledInstancesRequest.getScheduledInstanceId() != null) {
            request.addParameter("ScheduledInstanceId", StringUtils.fromString(runScheduledInstancesRequest.getScheduledInstanceId()));
        }
        if ((launchSpecification = runScheduledInstancesRequest.getLaunchSpecification()) != null) {
            ScheduledInstancesIamInstanceProfile iamInstanceProfile;
            SdkInternalList scheduledInstancesLaunchSpecificationNetworkInterfacesList;
            ScheduledInstancesMonitoring monitoring;
            SdkInternalList scheduledInstancesLaunchSpecificationBlockDeviceMappingsList;
            ScheduledInstancesPlacement placement;
            SdkInternalList scheduledInstancesLaunchSpecificationSecurityGroupIdsList;
            if (launchSpecification.getImageId() != null) {
                request.addParameter("LaunchSpecification.ImageId", StringUtils.fromString(launchSpecification.getImageId()));
            }
            if (launchSpecification.getKeyName() != null) {
                request.addParameter("LaunchSpecification.KeyName", StringUtils.fromString(launchSpecification.getKeyName()));
            }
            if (!(scheduledInstancesLaunchSpecificationSecurityGroupIdsList = (SdkInternalList)launchSpecification.getSecurityGroupIds()).isEmpty() || !scheduledInstancesLaunchSpecificationSecurityGroupIdsList.isAutoConstruct()) {
                int securityGroupIdsListIndex = 1;
                for (String scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue : scheduledInstancesLaunchSpecificationSecurityGroupIdsList) {
                    if (scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue != null) {
                        request.addParameter("LaunchSpecification.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString(scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue));
                    }
                    ++securityGroupIdsListIndex;
                }
            }
            if (launchSpecification.getUserData() != null) {
                request.addParameter("LaunchSpecification.UserData", StringUtils.fromString(launchSpecification.getUserData()));
            }
            if ((placement = launchSpecification.getPlacement()) != null) {
                if (placement.getAvailabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString(placement.getAvailabilityZone()));
                }
                if (placement.getGroupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString(placement.getGroupName()));
                }
            }
            if (launchSpecification.getKernelId() != null) {
                request.addParameter("LaunchSpecification.KernelId", StringUtils.fromString(launchSpecification.getKernelId()));
            }
            if (launchSpecification.getInstanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString(launchSpecification.getInstanceType()));
            }
            if (launchSpecification.getRamdiskId() != null) {
                request.addParameter("LaunchSpecification.RamdiskId", StringUtils.fromString(launchSpecification.getRamdiskId()));
            }
            if (!(scheduledInstancesLaunchSpecificationBlockDeviceMappingsList = (SdkInternalList)launchSpecification.getBlockDeviceMappings()).isEmpty() || !scheduledInstancesLaunchSpecificationBlockDeviceMappingsList.isAutoConstruct()) {
                int blockDeviceMappingsListIndex = 1;
                for (ScheduledInstancesBlockDeviceMapping scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue : scheduledInstancesLaunchSpecificationBlockDeviceMappingsList) {
                    ScheduledInstancesEbs ebs;
                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.getDeviceName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString(scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.getDeviceName()));
                    }
                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.getNoDevice() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString(scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.getNoDevice()));
                    }
                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.getVirtualName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString(scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.getVirtualName()));
                    }
                    if ((ebs = scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.getEbs()) != null) {
                        if (ebs.getSnapshotId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString(ebs.getSnapshotId()));
                        }
                        if (ebs.getVolumeSize() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger(ebs.getVolumeSize()));
                        }
                        if (ebs.getDeleteOnTermination() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebs.getDeleteOnTermination()));
                        }
                        if (ebs.getVolumeType() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString(ebs.getVolumeType()));
                        }
                        if (ebs.getIops() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger(ebs.getIops()));
                        }
                        if (ebs.getEncrypted() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean(ebs.getEncrypted()));
                        }
                    }
                    ++blockDeviceMappingsListIndex;
                }
            }
            if ((monitoring = launchSpecification.getMonitoring()) != null && monitoring.getEnabled() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean(monitoring.getEnabled()));
            }
            if (launchSpecification.getSubnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString(launchSpecification.getSubnetId()));
            }
            if (!(scheduledInstancesLaunchSpecificationNetworkInterfacesList = (SdkInternalList)launchSpecification.getNetworkInterfaces()).isEmpty() || !scheduledInstancesLaunchSpecificationNetworkInterfacesList.isAutoConstruct()) {
                int networkInterfacesListIndex = 1;
                for (ScheduledInstancesNetworkInterface scheduledInstancesLaunchSpecificationNetworkInterfacesListValue : scheduledInstancesLaunchSpecificationNetworkInterfacesList) {
                    SdkInternalList scheduledInstancesNetworkInterfaceIpv6AddressesList;
                    SdkInternalList scheduledInstancesNetworkInterfaceGroupsList;
                    SdkInternalList scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList;
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getNetworkInterfaceId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getNetworkInterfaceId()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getDeviceIndex() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getDeviceIndex()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getSubnetId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getSubnetId()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getDescription() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getDescription()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddress()));
                    }
                    if (!(scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList = (SdkInternalList)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddressConfigs()).isEmpty() || !scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList.isAutoConstruct()) {
                        int privateIpAddressConfigsListIndex = 1;
                        for (Object scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue : scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList) {
                            if (((ScheduledInstancesPrivateIpAddressConfig)scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue).getPrivateIpAddress() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddressConfig." + privateIpAddressConfigsListIndex + ".PrivateIpAddress", StringUtils.fromString(((ScheduledInstancesPrivateIpAddressConfig)scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue).getPrivateIpAddress()));
                            }
                            if (((ScheduledInstancesPrivateIpAddressConfig)scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue).getPrimary() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddressConfig." + privateIpAddressConfigsListIndex + ".Primary", StringUtils.fromBoolean(((ScheduledInstancesPrivateIpAddressConfig)scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue).getPrimary()));
                            }
                            ++privateIpAddressConfigsListIndex;
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getAssociatePublicIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getAssociatePublicIpAddress()));
                    }
                    if (!(scheduledInstancesNetworkInterfaceGroupsList = (SdkInternalList)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getGroups()).isEmpty() || !scheduledInstancesNetworkInterfaceGroupsList.isAutoConstruct()) {
                        Object scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue;
                        int groupsListIndex = 1;
                        scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue = scheduledInstancesNetworkInterfaceGroupsList.iterator();
                        while (scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.hasNext()) {
                            String scheduledInstancesNetworkInterfaceGroupsListValue = (String)scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.next();
                            if (scheduledInstancesNetworkInterfaceGroupsListValue != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Group." + groupsListIndex, StringUtils.fromString(scheduledInstancesNetworkInterfaceGroupsListValue));
                            }
                            ++groupsListIndex;
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getDeleteOnTermination() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getDeleteOnTermination()));
                    }
                    if (!(scheduledInstancesNetworkInterfaceIpv6AddressesList = (SdkInternalList)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getIpv6Addresses()).isEmpty() || !scheduledInstancesNetworkInterfaceIpv6AddressesList.isAutoConstruct()) {
                        int ipv6AddressesListIndex = 1;
                        for (ScheduledInstancesIpv6Address scheduledInstancesNetworkInterfaceIpv6AddressesListValue : scheduledInstancesNetworkInterfaceIpv6AddressesList) {
                            if (scheduledInstancesNetworkInterfaceIpv6AddressesListValue.getIpv6Address() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6Address." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString(scheduledInstancesNetworkInterfaceIpv6AddressesListValue.getIpv6Address()));
                            }
                            ++ipv6AddressesListIndex;
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getIpv6AddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getIpv6AddressCount()));
                    }
                    ++networkInterfacesListIndex;
                }
            }
            if ((iamInstanceProfile = launchSpecification.getIamInstanceProfile()) != null) {
                if (iamInstanceProfile.getArn() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Arn", StringUtils.fromString(iamInstanceProfile.getArn()));
                }
                if (iamInstanceProfile.getName() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Name", StringUtils.fromString(iamInstanceProfile.getName()));
                }
            }
            if (launchSpecification.getEbsOptimized() != null) {
                request.addParameter("LaunchSpecification.EbsOptimized", StringUtils.fromBoolean(launchSpecification.getEbsOptimized()));
            }
        }
        return request;
    }
}

