/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.InstanceAttributeName;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import com.amazonaws.services.ec2.model.transform.ModifyInstanceAttributeRequestMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyInstanceAttributeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ModifyInstanceAttributeRequest> {
    private String instanceId;
    private String attribute;
    private String value;
    private SdkInternalList<InstanceBlockDeviceMappingSpecification> blockDeviceMappings;
    private Boolean sourceDestCheck;
    private Boolean disableApiTermination;
    private String instanceType;
    private String kernel;
    private String ramdisk;
    private String userData;
    private String instanceInitiatedShutdownBehavior;
    private SdkInternalList<String> groups;
    private Boolean ebsOptimized;
    private String sriovNetSupport;
    private Boolean enaSupport;

    public ModifyInstanceAttributeRequest() {
    }

    public ModifyInstanceAttributeRequest(String instanceId, String attribute) {
        this.setInstanceId(instanceId);
        this.setAttribute(attribute);
    }

    public ModifyInstanceAttributeRequest(String instanceId, InstanceAttributeName attribute) {
        this.setInstanceId(instanceId);
        this.setAttribute(attribute.toString());
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ModifyInstanceAttributeRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public ModifyInstanceAttributeRequest withAttribute(String attribute) {
        this.setAttribute(attribute);
        return this;
    }

    @JsonIgnore
    public void setAttribute(InstanceAttributeName attribute) {
        this.attribute = attribute.toString();
    }

    public ModifyInstanceAttributeRequest withAttribute(InstanceAttributeName attribute) {
        this.setAttribute(attribute);
        return this;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public ModifyInstanceAttributeRequest withValue(String value) {
        this.setValue(value);
        return this;
    }

    public List<InstanceBlockDeviceMappingSpecification> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new SdkInternalList();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new SdkInternalList<InstanceBlockDeviceMappingSpecification>(blockDeviceMappings);
    }

    public ModifyInstanceAttributeRequest withBlockDeviceMappings(InstanceBlockDeviceMappingSpecification ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings(new SdkInternalList<InstanceBlockDeviceMappingSpecification>(blockDeviceMappings.length));
        }
        for (InstanceBlockDeviceMappingSpecification ele : blockDeviceMappings) {
            this.blockDeviceMappings.add(ele);
        }
        return this;
    }

    public ModifyInstanceAttributeRequest withBlockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public void setSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
    }

    public Boolean getSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public ModifyInstanceAttributeRequest withSourceDestCheck(Boolean sourceDestCheck) {
        this.setSourceDestCheck(sourceDestCheck);
        return this;
    }

    public Boolean isSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public void setDisableApiTermination(Boolean disableApiTermination) {
        this.disableApiTermination = disableApiTermination;
    }

    public Boolean getDisableApiTermination() {
        return this.disableApiTermination;
    }

    public ModifyInstanceAttributeRequest withDisableApiTermination(Boolean disableApiTermination) {
        this.setDisableApiTermination(disableApiTermination);
        return this;
    }

    public Boolean isDisableApiTermination() {
        return this.disableApiTermination;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public ModifyInstanceAttributeRequest withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setKernel(String kernel) {
        this.kernel = kernel;
    }

    public String getKernel() {
        return this.kernel;
    }

    public ModifyInstanceAttributeRequest withKernel(String kernel) {
        this.setKernel(kernel);
        return this;
    }

    public void setRamdisk(String ramdisk) {
        this.ramdisk = ramdisk;
    }

    public String getRamdisk() {
        return this.ramdisk;
    }

    public ModifyInstanceAttributeRequest withRamdisk(String ramdisk) {
        this.setRamdisk(ramdisk);
        return this;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public String getUserData() {
        return this.userData;
    }

    public ModifyInstanceAttributeRequest withUserData(String userData) {
        this.setUserData(userData);
        return this;
    }

    public void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
    }

    public String getInstanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public ModifyInstanceAttributeRequest withInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.setInstanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
        return this;
    }

    public List<String> getGroups() {
        if (this.groups == null) {
            this.groups = new SdkInternalList();
        }
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new SdkInternalList<String>(groups);
    }

    public ModifyInstanceAttributeRequest withGroups(String ... groups) {
        if (this.groups == null) {
            this.setGroups(new SdkInternalList<String>(groups.length));
        }
        for (String ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public ModifyInstanceAttributeRequest withGroups(Collection<String> groups) {
        this.setGroups(groups);
        return this;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public ModifyInstanceAttributeRequest withEbsOptimized(Boolean ebsOptimized) {
        this.setEbsOptimized(ebsOptimized);
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setSriovNetSupport(String sriovNetSupport) {
        this.sriovNetSupport = sriovNetSupport;
    }

    public String getSriovNetSupport() {
        return this.sriovNetSupport;
    }

    public ModifyInstanceAttributeRequest withSriovNetSupport(String sriovNetSupport) {
        this.setSriovNetSupport(sriovNetSupport);
        return this;
    }

    public void setEnaSupport(Boolean enaSupport) {
        this.enaSupport = enaSupport;
    }

    public Boolean getEnaSupport() {
        return this.enaSupport;
    }

    public ModifyInstanceAttributeRequest withEnaSupport(Boolean enaSupport) {
        this.setEnaSupport(enaSupport);
        return this;
    }

    public Boolean isEnaSupport() {
        return this.enaSupport;
    }

    @Override
    public Request<ModifyInstanceAttributeRequest> getDryRunRequest() {
        Request<ModifyInstanceAttributeRequest> request = new ModifyInstanceAttributeRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getAttribute() != null) {
            sb.append("Attribute: ").append(this.getAttribute()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings()).append(",");
        }
        if (this.getSourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(this.getSourceDestCheck()).append(",");
        }
        if (this.getDisableApiTermination() != null) {
            sb.append("DisableApiTermination: ").append(this.getDisableApiTermination()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getKernel() != null) {
            sb.append("Kernel: ").append(this.getKernel()).append(",");
        }
        if (this.getRamdisk() != null) {
            sb.append("Ramdisk: ").append(this.getRamdisk()).append(",");
        }
        if (this.getUserData() != null) {
            sb.append("UserData: ").append(this.getUserData()).append(",");
        }
        if (this.getInstanceInitiatedShutdownBehavior() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: ").append(this.getInstanceInitiatedShutdownBehavior()).append(",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups()).append(",");
        }
        if (this.getEbsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.getEbsOptimized()).append(",");
        }
        if (this.getSriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(this.getSriovNetSupport()).append(",");
        }
        if (this.getEnaSupport() != null) {
            sb.append("EnaSupport: ").append(this.getEnaSupport());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceAttributeRequest)) {
            return false;
        }
        ModifyInstanceAttributeRequest other = (ModifyInstanceAttributeRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getAttribute() == null ^ this.getAttribute() == null) {
            return false;
        }
        if (other.getAttribute() != null && !other.getAttribute().equals(this.getAttribute())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getSourceDestCheck() == null ^ this.getSourceDestCheck() == null) {
            return false;
        }
        if (other.getSourceDestCheck() != null && !other.getSourceDestCheck().equals(this.getSourceDestCheck())) {
            return false;
        }
        if (other.getDisableApiTermination() == null ^ this.getDisableApiTermination() == null) {
            return false;
        }
        if (other.getDisableApiTermination() != null && !other.getDisableApiTermination().equals(this.getDisableApiTermination())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getKernel() == null ^ this.getKernel() == null) {
            return false;
        }
        if (other.getKernel() != null && !other.getKernel().equals(this.getKernel())) {
            return false;
        }
        if (other.getRamdisk() == null ^ this.getRamdisk() == null) {
            return false;
        }
        if (other.getRamdisk() != null && !other.getRamdisk().equals(this.getRamdisk())) {
            return false;
        }
        if (other.getUserData() == null ^ this.getUserData() == null) {
            return false;
        }
        if (other.getUserData() != null && !other.getUserData().equals(this.getUserData())) {
            return false;
        }
        if (other.getInstanceInitiatedShutdownBehavior() == null ^ this.getInstanceInitiatedShutdownBehavior() == null) {
            return false;
        }
        if (other.getInstanceInitiatedShutdownBehavior() != null && !other.getInstanceInitiatedShutdownBehavior().equals(this.getInstanceInitiatedShutdownBehavior())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getEbsOptimized() == null ^ this.getEbsOptimized() == null) {
            return false;
        }
        if (other.getEbsOptimized() != null && !other.getEbsOptimized().equals(this.getEbsOptimized())) {
            return false;
        }
        if (other.getSriovNetSupport() == null ^ this.getSriovNetSupport() == null) {
            return false;
        }
        if (other.getSriovNetSupport() != null && !other.getSriovNetSupport().equals(this.getSriovNetSupport())) {
            return false;
        }
        if (other.getEnaSupport() == null ^ this.getEnaSupport() == null) {
            return false;
        }
        return other.getEnaSupport() == null || other.getEnaSupport().equals(this.getEnaSupport());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getAttribute() == null ? 0 : this.getAttribute().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getSourceDestCheck() == null ? 0 : this.getSourceDestCheck().hashCode());
        hashCode = 31 * hashCode + (this.getDisableApiTermination() == null ? 0 : this.getDisableApiTermination().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getKernel() == null ? 0 : this.getKernel().hashCode());
        hashCode = 31 * hashCode + (this.getRamdisk() == null ? 0 : this.getRamdisk().hashCode());
        hashCode = 31 * hashCode + (this.getUserData() == null ? 0 : this.getUserData().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceInitiatedShutdownBehavior() == null ? 0 : this.getInstanceInitiatedShutdownBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getEbsOptimized() == null ? 0 : this.getEbsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.getSriovNetSupport() == null ? 0 : this.getSriovNetSupport().hashCode());
        hashCode = 31 * hashCode + (this.getEnaSupport() == null ? 0 : this.getEnaSupport().hashCode());
        return hashCode;
    }

    @Override
    public ModifyInstanceAttributeRequest clone() {
        return (ModifyInstanceAttributeRequest)super.clone();
    }
}

