/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudsearchdomain.AmazonCloudSearchDomainAsync;
import com.amazonaws.services.cloudsearchdomain.AmazonCloudSearchDomainAsyncClientBuilder;
import com.amazonaws.services.cloudsearchdomain.AmazonCloudSearchDomainClient;
import com.amazonaws.services.cloudsearchdomain.model.SearchRequest;
import com.amazonaws.services.cloudsearchdomain.model.SearchResult;
import com.amazonaws.services.cloudsearchdomain.model.SuggestRequest;
import com.amazonaws.services.cloudsearchdomain.model.SuggestResult;
import com.amazonaws.services.cloudsearchdomain.model.UploadDocumentsRequest;
import com.amazonaws.services.cloudsearchdomain.model.UploadDocumentsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCloudSearchDomainAsyncClient
extends AmazonCloudSearchDomainClient
implements AmazonCloudSearchDomainAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonCloudSearchDomainAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonCloudSearchDomainAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCloudSearchDomainAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCloudSearchDomainAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCloudSearchDomainAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonCloudSearchDomainAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCloudSearchDomainAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCloudSearchDomainAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCloudSearchDomainAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonCloudSearchDomainAsyncClientBuilder asyncBuilder() {
        return AmazonCloudSearchDomainAsyncClientBuilder.standard();
    }

    AmazonCloudSearchDomainAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<SearchResult> searchAsync(SearchRequest request) {
        return this.searchAsync(request, null);
    }

    @Override
    public Future<SearchResult> searchAsync(final SearchRequest request, final AsyncHandler<SearchRequest, SearchResult> asyncHandler) {
        return this.executorService.submit(new Callable<SearchResult>(){

            @Override
            public SearchResult call() throws Exception {
                SearchResult result;
                try {
                    result = AmazonCloudSearchDomainAsyncClient.this.search(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SuggestResult> suggestAsync(SuggestRequest request) {
        return this.suggestAsync(request, null);
    }

    @Override
    public Future<SuggestResult> suggestAsync(final SuggestRequest request, final AsyncHandler<SuggestRequest, SuggestResult> asyncHandler) {
        return this.executorService.submit(new Callable<SuggestResult>(){

            @Override
            public SuggestResult call() throws Exception {
                SuggestResult result;
                try {
                    result = AmazonCloudSearchDomainAsyncClient.this.suggest(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UploadDocumentsResult> uploadDocumentsAsync(UploadDocumentsRequest request) {
        return this.uploadDocumentsAsync(request, null);
    }

    @Override
    public Future<UploadDocumentsResult> uploadDocumentsAsync(final UploadDocumentsRequest request, final AsyncHandler<UploadDocumentsRequest, UploadDocumentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<UploadDocumentsResult>(){

            @Override
            public UploadDocumentsResult call() throws Exception {
                UploadDocumentsResult result;
                try {
                    result = AmazonCloudSearchDomainAsyncClient.this.uploadDocuments(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

