/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.budgets.model.DescribeSubscribersForNotificationRequest;
import com.amazonaws.services.budgets.model.transform.NotificationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeSubscribersForNotificationRequestMarshaller
implements Marshaller<Request<DescribeSubscribersForNotificationRequest>, DescribeSubscribersForNotificationRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeSubscribersForNotificationRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeSubscribersForNotificationRequest> marshall(DescribeSubscribersForNotificationRequest describeSubscribersForNotificationRequest) {
        if (describeSubscribersForNotificationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSubscribersForNotificationRequest, "AWSBudgets");
        request.addHeader("X-Amz-Target", "AWSBudgetServiceGateway.DescribeSubscribersForNotification");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeSubscribersForNotificationRequest.getAccountId() != null) {
                jsonGenerator.writeFieldName("AccountId").writeValue(describeSubscribersForNotificationRequest.getAccountId());
            }
            if (describeSubscribersForNotificationRequest.getBudgetName() != null) {
                jsonGenerator.writeFieldName("BudgetName").writeValue(describeSubscribersForNotificationRequest.getBudgetName());
            }
            if (describeSubscribersForNotificationRequest.getNotification() != null) {
                jsonGenerator.writeFieldName("Notification");
                NotificationJsonMarshaller.getInstance().marshall(describeSubscribersForNotificationRequest.getNotification(), jsonGenerator);
            }
            if (describeSubscribersForNotificationRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(describeSubscribersForNotificationRequest.getMaxResults().intValue());
            }
            if (describeSubscribersForNotificationRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeSubscribersForNotificationRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

