/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.budgets.model.Budget;
import com.amazonaws.services.budgets.model.NotificationWithSubscribers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateBudgetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String accountId;
    private Budget budget;
    private List<NotificationWithSubscribers> notificationsWithSubscribers;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public CreateBudgetRequest withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public CreateBudgetRequest withBudget(Budget budget) {
        this.setBudget(budget);
        return this;
    }

    public List<NotificationWithSubscribers> getNotificationsWithSubscribers() {
        return this.notificationsWithSubscribers;
    }

    public void setNotificationsWithSubscribers(Collection<NotificationWithSubscribers> notificationsWithSubscribers) {
        if (notificationsWithSubscribers == null) {
            this.notificationsWithSubscribers = null;
            return;
        }
        this.notificationsWithSubscribers = new ArrayList<NotificationWithSubscribers>(notificationsWithSubscribers);
    }

    public CreateBudgetRequest withNotificationsWithSubscribers(NotificationWithSubscribers ... notificationsWithSubscribers) {
        if (this.notificationsWithSubscribers == null) {
            this.setNotificationsWithSubscribers(new ArrayList<NotificationWithSubscribers>(notificationsWithSubscribers.length));
        }
        for (NotificationWithSubscribers ele : notificationsWithSubscribers) {
            this.notificationsWithSubscribers.add(ele);
        }
        return this;
    }

    public CreateBudgetRequest withNotificationsWithSubscribers(Collection<NotificationWithSubscribers> notificationsWithSubscribers) {
        this.setNotificationsWithSubscribers(notificationsWithSubscribers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getBudget() != null) {
            sb.append("Budget: ").append(this.getBudget()).append(",");
        }
        if (this.getNotificationsWithSubscribers() != null) {
            sb.append("NotificationsWithSubscribers: ").append(this.getNotificationsWithSubscribers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBudgetRequest)) {
            return false;
        }
        CreateBudgetRequest other = (CreateBudgetRequest)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getBudget() == null ^ this.getBudget() == null) {
            return false;
        }
        if (other.getBudget() != null && !other.getBudget().equals(this.getBudget())) {
            return false;
        }
        if (other.getNotificationsWithSubscribers() == null ^ this.getNotificationsWithSubscribers() == null) {
            return false;
        }
        return other.getNotificationsWithSubscribers() == null || other.getNotificationsWithSubscribers().equals(this.getNotificationsWithSubscribers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getBudget() == null ? 0 : this.getBudget().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationsWithSubscribers() == null ? 0 : this.getNotificationsWithSubscribers().hashCode());
        return hashCode;
    }

    public CreateBudgetRequest clone() {
        return (CreateBudgetRequest)super.clone();
    }
}

