/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.budgets.model.CreateSubscriberRequest;
import com.amazonaws.services.budgets.model.transform.NotificationJsonMarshaller;
import com.amazonaws.services.budgets.model.transform.SubscriberJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateSubscriberRequestMarshaller
implements Marshaller<Request<CreateSubscriberRequest>, CreateSubscriberRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateSubscriberRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateSubscriberRequest> marshall(CreateSubscriberRequest createSubscriberRequest) {
        if (createSubscriberRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSubscriberRequest, "AWSBudgets");
        request.addHeader("X-Amz-Target", "AWSBudgetServiceGateway.CreateSubscriber");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createSubscriberRequest.getAccountId() != null) {
                jsonGenerator.writeFieldName("AccountId").writeValue(createSubscriberRequest.getAccountId());
            }
            if (createSubscriberRequest.getBudgetName() != null) {
                jsonGenerator.writeFieldName("BudgetName").writeValue(createSubscriberRequest.getBudgetName());
            }
            if (createSubscriberRequest.getNotification() != null) {
                jsonGenerator.writeFieldName("Notification");
                NotificationJsonMarshaller.getInstance().marshall(createSubscriberRequest.getNotification(), jsonGenerator);
            }
            if (createSubscriberRequest.getSubscriber() != null) {
                jsonGenerator.writeFieldName("Subscriber");
                SubscriberJsonMarshaller.getInstance().marshall(createSubscriberRequest.getSubscriber(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

