/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.budgets.AWSBudgets;
import com.amazonaws.services.budgets.model.AWSBudgetsException;
import com.amazonaws.services.budgets.model.CreateBudgetRequest;
import com.amazonaws.services.budgets.model.CreateBudgetResult;
import com.amazonaws.services.budgets.model.CreateNotificationRequest;
import com.amazonaws.services.budgets.model.CreateNotificationResult;
import com.amazonaws.services.budgets.model.CreateSubscriberRequest;
import com.amazonaws.services.budgets.model.CreateSubscriberResult;
import com.amazonaws.services.budgets.model.CreationLimitExceededException;
import com.amazonaws.services.budgets.model.DeleteBudgetRequest;
import com.amazonaws.services.budgets.model.DeleteBudgetResult;
import com.amazonaws.services.budgets.model.DeleteNotificationRequest;
import com.amazonaws.services.budgets.model.DeleteNotificationResult;
import com.amazonaws.services.budgets.model.DeleteSubscriberRequest;
import com.amazonaws.services.budgets.model.DeleteSubscriberResult;
import com.amazonaws.services.budgets.model.DescribeBudgetRequest;
import com.amazonaws.services.budgets.model.DescribeBudgetResult;
import com.amazonaws.services.budgets.model.DescribeBudgetsRequest;
import com.amazonaws.services.budgets.model.DescribeBudgetsResult;
import com.amazonaws.services.budgets.model.DescribeNotificationsForBudgetRequest;
import com.amazonaws.services.budgets.model.DescribeNotificationsForBudgetResult;
import com.amazonaws.services.budgets.model.DescribeSubscribersForNotificationRequest;
import com.amazonaws.services.budgets.model.DescribeSubscribersForNotificationResult;
import com.amazonaws.services.budgets.model.DuplicateRecordException;
import com.amazonaws.services.budgets.model.ExpiredNextTokenException;
import com.amazonaws.services.budgets.model.InternalErrorException;
import com.amazonaws.services.budgets.model.InvalidNextTokenException;
import com.amazonaws.services.budgets.model.InvalidParameterException;
import com.amazonaws.services.budgets.model.NotFoundException;
import com.amazonaws.services.budgets.model.UpdateBudgetRequest;
import com.amazonaws.services.budgets.model.UpdateBudgetResult;
import com.amazonaws.services.budgets.model.UpdateNotificationRequest;
import com.amazonaws.services.budgets.model.UpdateNotificationResult;
import com.amazonaws.services.budgets.model.UpdateSubscriberRequest;
import com.amazonaws.services.budgets.model.UpdateSubscriberResult;
import com.amazonaws.services.budgets.model.transform.CreateBudgetRequestMarshaller;
import com.amazonaws.services.budgets.model.transform.CreateBudgetResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.CreateNotificationRequestMarshaller;
import com.amazonaws.services.budgets.model.transform.CreateNotificationResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.CreateSubscriberRequestMarshaller;
import com.amazonaws.services.budgets.model.transform.CreateSubscriberResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DeleteBudgetRequestMarshaller;
import com.amazonaws.services.budgets.model.transform.DeleteBudgetResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DeleteNotificationRequestMarshaller;
import com.amazonaws.services.budgets.model.transform.DeleteNotificationResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DeleteSubscriberRequestMarshaller;
import com.amazonaws.services.budgets.model.transform.DeleteSubscriberResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetRequestMarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetsRequestMarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeBudgetsResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeNotificationsForBudgetRequestMarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeNotificationsForBudgetResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeSubscribersForNotificationRequestMarshaller;
import com.amazonaws.services.budgets.model.transform.DescribeSubscribersForNotificationResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.UpdateBudgetRequestMarshaller;
import com.amazonaws.services.budgets.model.transform.UpdateBudgetResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.UpdateNotificationRequestMarshaller;
import com.amazonaws.services.budgets.model.transform.UpdateNotificationResultJsonUnmarshaller;
import com.amazonaws.services.budgets.model.transform.UpdateSubscriberRequestMarshaller;
import com.amazonaws.services.budgets.model.transform.UpdateSubscriberResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSBudgetsClient
extends AmazonWebServiceClient
implements AWSBudgets {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSBudgets.class);
    private static final String DEFAULT_SIGNING_NAME = "budgets";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateRecordException").withModeledClass(DuplicateRecordException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalErrorException").withModeledClass(InternalErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CreationLimitExceededException").withModeledClass(CreationLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredNextTokenException").withModeledClass(ExpiredNextTokenException.class)).withBaseServiceExceptionClass(AWSBudgetsException.class));

    public AWSBudgetsClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    public AWSBudgetsClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    public AWSBudgetsClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AWSBudgetsClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSBudgetsClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AWSBudgetsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSBudgetsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AWSBudgetsClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("budgets.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/budgets/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/budgets/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBudgetResult createBudget(CreateBudgetRequest createBudgetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBudgetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBudgetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBudgetRequestMarshaller(this.protocolFactory).marshall((CreateBudgetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBudgetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBudgetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBudgetResult createBudgetResult = (CreateBudgetResult)response.getAwsResponse();
            return createBudgetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNotificationResult createNotification(CreateNotificationRequest createNotificationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createNotificationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateNotificationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateNotificationRequestMarshaller(this.protocolFactory).marshall((CreateNotificationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createNotificationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateNotificationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateNotificationResult createNotificationResult = (CreateNotificationResult)response.getAwsResponse();
            return createNotificationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSubscriberResult createSubscriber(CreateSubscriberRequest createSubscriberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSubscriberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSubscriberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSubscriberRequestMarshaller(this.protocolFactory).marshall((CreateSubscriberRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSubscriberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSubscriberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSubscriberResult createSubscriberResult = (CreateSubscriberResult)response.getAwsResponse();
            return createSubscriberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBudgetResult deleteBudget(DeleteBudgetRequest deleteBudgetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBudgetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBudgetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBudgetRequestMarshaller(this.protocolFactory).marshall((DeleteBudgetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBudgetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteBudgetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBudgetResult deleteBudgetResult = (DeleteBudgetResult)response.getAwsResponse();
            return deleteBudgetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNotificationResult deleteNotification(DeleteNotificationRequest deleteNotificationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteNotificationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteNotificationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteNotificationRequestMarshaller(this.protocolFactory).marshall((DeleteNotificationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteNotificationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteNotificationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteNotificationResult deleteNotificationResult = (DeleteNotificationResult)response.getAwsResponse();
            return deleteNotificationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSubscriberResult deleteSubscriber(DeleteSubscriberRequest deleteSubscriberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSubscriberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSubscriberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSubscriberRequestMarshaller(this.protocolFactory).marshall((DeleteSubscriberRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSubscriberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSubscriberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSubscriberResult deleteSubscriberResult = (DeleteSubscriberResult)response.getAwsResponse();
            return deleteSubscriberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBudgetResult describeBudget(DescribeBudgetRequest describeBudgetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBudgetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBudgetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBudgetRequestMarshaller(this.protocolFactory).marshall((DescribeBudgetRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBudgetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBudgetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBudgetResult describeBudgetResult = (DescribeBudgetResult)response.getAwsResponse();
            return describeBudgetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBudgetsResult describeBudgets(DescribeBudgetsRequest describeBudgetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBudgetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBudgetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBudgetsRequestMarshaller(this.protocolFactory).marshall((DescribeBudgetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBudgetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBudgetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBudgetsResult describeBudgetsResult = (DescribeBudgetsResult)response.getAwsResponse();
            return describeBudgetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeNotificationsForBudgetResult describeNotificationsForBudget(DescribeNotificationsForBudgetRequest describeNotificationsForBudgetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeNotificationsForBudgetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeNotificationsForBudgetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeNotificationsForBudgetRequestMarshaller(this.protocolFactory).marshall((DescribeNotificationsForBudgetRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeNotificationsForBudgetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeNotificationsForBudgetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeNotificationsForBudgetResult describeNotificationsForBudgetResult = (DescribeNotificationsForBudgetResult)response.getAwsResponse();
            return describeNotificationsForBudgetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSubscribersForNotificationResult describeSubscribersForNotification(DescribeSubscribersForNotificationRequest describeSubscribersForNotificationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSubscribersForNotificationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSubscribersForNotificationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSubscribersForNotificationRequestMarshaller(this.protocolFactory).marshall((DescribeSubscribersForNotificationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeSubscribersForNotificationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSubscribersForNotificationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSubscribersForNotificationResult describeSubscribersForNotificationResult = (DescribeSubscribersForNotificationResult)response.getAwsResponse();
            return describeSubscribersForNotificationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBudgetResult updateBudget(UpdateBudgetRequest updateBudgetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateBudgetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateBudgetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateBudgetRequestMarshaller(this.protocolFactory).marshall((UpdateBudgetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateBudgetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateBudgetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateBudgetResult updateBudgetResult = (UpdateBudgetResult)response.getAwsResponse();
            return updateBudgetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNotificationResult updateNotification(UpdateNotificationRequest updateNotificationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateNotificationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateNotificationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateNotificationRequestMarshaller(this.protocolFactory).marshall((UpdateNotificationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateNotificationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateNotificationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateNotificationResult updateNotificationResult = (UpdateNotificationResult)response.getAwsResponse();
            return updateNotificationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSubscriberResult updateSubscriber(UpdateSubscriberRequest updateSubscriberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSubscriberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSubscriberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSubscriberRequestMarshaller(this.protocolFactory).marshall((UpdateSubscriberRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSubscriberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSubscriberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSubscriberResult updateSubscriberResult = (UpdateSubscriberResult)response.getAwsResponse();
            return updateSubscriberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

