/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.billingconductor.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.billingconductor.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * BillingGroupListElement JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BillingGroupListElementJsonUnmarshaller implements Unmarshaller<BillingGroupListElement, JsonUnmarshallerContext> {

    public BillingGroupListElement unmarshall(JsonUnmarshallerContext context) throws Exception {
        BillingGroupListElement billingGroupListElement = new BillingGroupListElement();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    billingGroupListElement.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    billingGroupListElement.setArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    billingGroupListElement.setDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PrimaryAccountId", targetDepth)) {
                    context.nextToken();
                    billingGroupListElement.setPrimaryAccountId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ComputationPreference", targetDepth)) {
                    context.nextToken();
                    billingGroupListElement.setComputationPreference(ComputationPreferenceJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Size", targetDepth)) {
                    context.nextToken();
                    billingGroupListElement.setSize(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    billingGroupListElement.setCreationTime(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("LastModifiedTime", targetDepth)) {
                    context.nextToken();
                    billingGroupListElement.setLastModifiedTime(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    billingGroupListElement.setStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StatusReason", targetDepth)) {
                    context.nextToken();
                    billingGroupListElement.setStatusReason(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AccountGrouping", targetDepth)) {
                    context.nextToken();
                    billingGroupListElement.setAccountGrouping(ListBillingGroupAccountGroupingJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return billingGroupListElement;
    }

    private static BillingGroupListElementJsonUnmarshaller instance;

    public static BillingGroupListElementJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new BillingGroupListElementJsonUnmarshaller();
        return instance;
    }
}
