/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.billingconductor.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A representation of the charge details that are associated with a percentage custom line item.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CustomLineItemPercentageChargeDetails"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CustomLineItemPercentageChargeDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The custom line item's percentage value. This will be multiplied against the combined value of its associated
     * resources to determine its charge value.
     * </p>
     */
    private Double percentageValue;
    /**
     * <p>
     * A list of resource ARNs to associate to the percentage custom line item.
     * </p>
     */
    private java.util.List<String> associatedValues;

    /**
     * <p>
     * The custom line item's percentage value. This will be multiplied against the combined value of its associated
     * resources to determine its charge value.
     * </p>
     * 
     * @param percentageValue
     *        The custom line item's percentage value. This will be multiplied against the combined value of its
     *        associated resources to determine its charge value.
     */

    public void setPercentageValue(Double percentageValue) {
        this.percentageValue = percentageValue;
    }

    /**
     * <p>
     * The custom line item's percentage value. This will be multiplied against the combined value of its associated
     * resources to determine its charge value.
     * </p>
     * 
     * @return The custom line item's percentage value. This will be multiplied against the combined value of its
     *         associated resources to determine its charge value.
     */

    public Double getPercentageValue() {
        return this.percentageValue;
    }

    /**
     * <p>
     * The custom line item's percentage value. This will be multiplied against the combined value of its associated
     * resources to determine its charge value.
     * </p>
     * 
     * @param percentageValue
     *        The custom line item's percentage value. This will be multiplied against the combined value of its
     *        associated resources to determine its charge value.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CustomLineItemPercentageChargeDetails withPercentageValue(Double percentageValue) {
        setPercentageValue(percentageValue);
        return this;
    }

    /**
     * <p>
     * A list of resource ARNs to associate to the percentage custom line item.
     * </p>
     * 
     * @return A list of resource ARNs to associate to the percentage custom line item.
     */

    public java.util.List<String> getAssociatedValues() {
        return associatedValues;
    }

    /**
     * <p>
     * A list of resource ARNs to associate to the percentage custom line item.
     * </p>
     * 
     * @param associatedValues
     *        A list of resource ARNs to associate to the percentage custom line item.
     */

    public void setAssociatedValues(java.util.Collection<String> associatedValues) {
        if (associatedValues == null) {
            this.associatedValues = null;
            return;
        }

        this.associatedValues = new java.util.ArrayList<String>(associatedValues);
    }

    /**
     * <p>
     * A list of resource ARNs to associate to the percentage custom line item.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAssociatedValues(java.util.Collection)} or {@link #withAssociatedValues(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param associatedValues
     *        A list of resource ARNs to associate to the percentage custom line item.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CustomLineItemPercentageChargeDetails withAssociatedValues(String... associatedValues) {
        if (this.associatedValues == null) {
            setAssociatedValues(new java.util.ArrayList<String>(associatedValues.length));
        }
        for (String ele : associatedValues) {
            this.associatedValues.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of resource ARNs to associate to the percentage custom line item.
     * </p>
     * 
     * @param associatedValues
     *        A list of resource ARNs to associate to the percentage custom line item.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CustomLineItemPercentageChargeDetails withAssociatedValues(java.util.Collection<String> associatedValues) {
        setAssociatedValues(associatedValues);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getPercentageValue() != null)
            sb.append("PercentageValue: ").append(getPercentageValue()).append(",");
        if (getAssociatedValues() != null)
            sb.append("AssociatedValues: ").append(getAssociatedValues());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CustomLineItemPercentageChargeDetails == false)
            return false;
        CustomLineItemPercentageChargeDetails other = (CustomLineItemPercentageChargeDetails) obj;
        if (other.getPercentageValue() == null ^ this.getPercentageValue() == null)
            return false;
        if (other.getPercentageValue() != null && other.getPercentageValue().equals(this.getPercentageValue()) == false)
            return false;
        if (other.getAssociatedValues() == null ^ this.getAssociatedValues() == null)
            return false;
        if (other.getAssociatedValues() != null && other.getAssociatedValues().equals(this.getAssociatedValues()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getPercentageValue() == null) ? 0 : getPercentageValue().hashCode());
        hashCode = prime * hashCode + ((getAssociatedValues() == null) ? 0 : getAssociatedValues().hashCode());
        return hashCode;
    }

    @Override
    public CustomLineItemPercentageChargeDetails clone() {
        try {
            return (CustomLineItemPercentageChargeDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.billingconductor.model.transform.CustomLineItemPercentageChargeDetailsMarshaller.getInstance()
                .marshall(this, protocolMarshaller);
    }
}
