/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockruntime.model.DocumentFormat;
import com.amazonaws.services.bedrockruntime.model.DocumentSource;
import com.amazonaws.services.bedrockruntime.model.transform.DocumentBlockMarshaller;
import java.io.Serializable;

public class DocumentBlock
implements Serializable,
Cloneable,
StructuredPojo {
    private String format;
    private String name;
    private DocumentSource source;

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public DocumentBlock withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public DocumentBlock withFormat(DocumentFormat format) {
        this.format = format.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DocumentBlock withName(String name) {
        this.setName(name);
        return this;
    }

    public void setSource(DocumentSource source) {
        this.source = source;
    }

    public DocumentSource getSource() {
        return this.source;
    }

    public DocumentBlock withSource(DocumentSource source) {
        this.setSource(source);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentBlock)) {
            return false;
        }
        DocumentBlock other = (DocumentBlock)obj;
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        return other.getSource() == null || other.getSource().equals(this.getSource());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        return hashCode;
    }

    public DocumentBlock clone() {
        try {
            return (DocumentBlock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentBlockMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

