/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrockruntime.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The details for the guardrails contextual grounding filter.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/GuardrailContextualGroundingFilter"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GuardrailContextualGroundingFilter implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The contextual grounding filter type.
     * </p>
     */
    private String type;
    /**
     * <p>
     * The threshold used by contextual grounding filter to determine whether the content is grounded or not.
     * </p>
     */
    private Double threshold;
    /**
     * <p>
     * The score generated by contextual grounding filter.
     * </p>
     */
    private Double score;
    /**
     * <p>
     * The action performed by the guardrails contextual grounding filter.
     * </p>
     */
    private String action;

    /**
     * <p>
     * The contextual grounding filter type.
     * </p>
     * 
     * @param type
     *        The contextual grounding filter type.
     * @see GuardrailContextualGroundingFilterType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The contextual grounding filter type.
     * </p>
     * 
     * @return The contextual grounding filter type.
     * @see GuardrailContextualGroundingFilterType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The contextual grounding filter type.
     * </p>
     * 
     * @param type
     *        The contextual grounding filter type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GuardrailContextualGroundingFilterType
     */

    public GuardrailContextualGroundingFilter withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The contextual grounding filter type.
     * </p>
     * 
     * @param type
     *        The contextual grounding filter type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GuardrailContextualGroundingFilterType
     */

    public GuardrailContextualGroundingFilter withType(GuardrailContextualGroundingFilterType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * <p>
     * The threshold used by contextual grounding filter to determine whether the content is grounded or not.
     * </p>
     * 
     * @param threshold
     *        The threshold used by contextual grounding filter to determine whether the content is grounded or not.
     */

    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    /**
     * <p>
     * The threshold used by contextual grounding filter to determine whether the content is grounded or not.
     * </p>
     * 
     * @return The threshold used by contextual grounding filter to determine whether the content is grounded or not.
     */

    public Double getThreshold() {
        return this.threshold;
    }

    /**
     * <p>
     * The threshold used by contextual grounding filter to determine whether the content is grounded or not.
     * </p>
     * 
     * @param threshold
     *        The threshold used by contextual grounding filter to determine whether the content is grounded or not.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GuardrailContextualGroundingFilter withThreshold(Double threshold) {
        setThreshold(threshold);
        return this;
    }

    /**
     * <p>
     * The score generated by contextual grounding filter.
     * </p>
     * 
     * @param score
     *        The score generated by contextual grounding filter.
     */

    public void setScore(Double score) {
        this.score = score;
    }

    /**
     * <p>
     * The score generated by contextual grounding filter.
     * </p>
     * 
     * @return The score generated by contextual grounding filter.
     */

    public Double getScore() {
        return this.score;
    }

    /**
     * <p>
     * The score generated by contextual grounding filter.
     * </p>
     * 
     * @param score
     *        The score generated by contextual grounding filter.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GuardrailContextualGroundingFilter withScore(Double score) {
        setScore(score);
        return this;
    }

    /**
     * <p>
     * The action performed by the guardrails contextual grounding filter.
     * </p>
     * 
     * @param action
     *        The action performed by the guardrails contextual grounding filter.
     * @see GuardrailContextualGroundingPolicyAction
     */

    public void setAction(String action) {
        this.action = action;
    }

    /**
     * <p>
     * The action performed by the guardrails contextual grounding filter.
     * </p>
     * 
     * @return The action performed by the guardrails contextual grounding filter.
     * @see GuardrailContextualGroundingPolicyAction
     */

    public String getAction() {
        return this.action;
    }

    /**
     * <p>
     * The action performed by the guardrails contextual grounding filter.
     * </p>
     * 
     * @param action
     *        The action performed by the guardrails contextual grounding filter.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GuardrailContextualGroundingPolicyAction
     */

    public GuardrailContextualGroundingFilter withAction(String action) {
        setAction(action);
        return this;
    }

    /**
     * <p>
     * The action performed by the guardrails contextual grounding filter.
     * </p>
     * 
     * @param action
     *        The action performed by the guardrails contextual grounding filter.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GuardrailContextualGroundingPolicyAction
     */

    public GuardrailContextualGroundingFilter withAction(GuardrailContextualGroundingPolicyAction action) {
        this.action = action.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getType() != null)
            sb.append("Type: ").append(getType()).append(",");
        if (getThreshold() != null)
            sb.append("Threshold: ").append(getThreshold()).append(",");
        if (getScore() != null)
            sb.append("Score: ").append(getScore()).append(",");
        if (getAction() != null)
            sb.append("Action: ").append(getAction());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GuardrailContextualGroundingFilter == false)
            return false;
        GuardrailContextualGroundingFilter other = (GuardrailContextualGroundingFilter) obj;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        if (other.getThreshold() == null ^ this.getThreshold() == null)
            return false;
        if (other.getThreshold() != null && other.getThreshold().equals(this.getThreshold()) == false)
            return false;
        if (other.getScore() == null ^ this.getScore() == null)
            return false;
        if (other.getScore() != null && other.getScore().equals(this.getScore()) == false)
            return false;
        if (other.getAction() == null ^ this.getAction() == null)
            return false;
        if (other.getAction() != null && other.getAction().equals(this.getAction()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        hashCode = prime * hashCode + ((getThreshold() == null) ? 0 : getThreshold().hashCode());
        hashCode = prime * hashCode + ((getScore() == null) ? 0 : getScore().hashCode());
        hashCode = prime * hashCode + ((getAction() == null) ? 0 : getAction().hashCode());
        return hashCode;
    }

    @Override
    public GuardrailContextualGroundingFilter clone() {
        try {
            return (GuardrailContextualGroundingFilter) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.bedrockruntime.model.transform.GuardrailContextualGroundingFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
