/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrockruntime.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The trace object in a response from <a
 * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a>. Currently, you
 * can only trace guardrails.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/ConverseTrace" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ConverseTrace implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The guardrail trace object.
     * </p>
     */
    private GuardrailTraceAssessment guardrail;

    /**
     * <p>
     * The guardrail trace object.
     * </p>
     * 
     * @param guardrail
     *        The guardrail trace object.
     */

    public void setGuardrail(GuardrailTraceAssessment guardrail) {
        this.guardrail = guardrail;
    }

    /**
     * <p>
     * The guardrail trace object.
     * </p>
     * 
     * @return The guardrail trace object.
     */

    public GuardrailTraceAssessment getGuardrail() {
        return this.guardrail;
    }

    /**
     * <p>
     * The guardrail trace object.
     * </p>
     * 
     * @param guardrail
     *        The guardrail trace object.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ConverseTrace withGuardrail(GuardrailTraceAssessment guardrail) {
        setGuardrail(guardrail);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getGuardrail() != null)
            sb.append("Guardrail: ").append(getGuardrail());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ConverseTrace == false)
            return false;
        ConverseTrace other = (ConverseTrace) obj;
        if (other.getGuardrail() == null ^ this.getGuardrail() == null)
            return false;
        if (other.getGuardrail() != null && other.getGuardrail().equals(this.getGuardrail()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getGuardrail() == null) ? 0 : getGuardrail().hashCode());
        return hashCode;
    }

    @Override
    public ConverseTrace clone() {
        try {
            return (ConverseTrace) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.bedrockruntime.model.transform.ConverseTraceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
