/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagentruntime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagentruntime.model.ExternalSource;

@SdkInternalApi
public class ExternalSourceMarshaller {
    private static final MarshallingInfo<StructuredPojo> BYTECONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("byteContent").build();
    private static final MarshallingInfo<StructuredPojo> S3LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Location").build();
    private static final MarshallingInfo<String> SOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceType").build();
    private static final ExternalSourceMarshaller instance = new ExternalSourceMarshaller();

    public static ExternalSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExternalSource externalSource, ProtocolMarshaller protocolMarshaller) {
        if (externalSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)externalSource.getByteContent(), BYTECONTENT_BINDING);
            protocolMarshaller.marshall((Object)externalSource.getS3Location(), S3LOCATION_BINDING);
            protocolMarshaller.marshall((Object)externalSource.getSourceType(), SOURCETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

