/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagentruntime;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.bedrockagentruntime.AWSBedrockAgentRuntime;
import com.amazonaws.services.bedrockagentruntime.AWSBedrockAgentRuntimeClientBuilder;
import com.amazonaws.services.bedrockagentruntime.model.AWSBedrockAgentRuntimeException;
import com.amazonaws.services.bedrockagentruntime.model.DeleteAgentMemoryRequest;
import com.amazonaws.services.bedrockagentruntime.model.DeleteAgentMemoryResult;
import com.amazonaws.services.bedrockagentruntime.model.GetAgentMemoryRequest;
import com.amazonaws.services.bedrockagentruntime.model.GetAgentMemoryResult;
import com.amazonaws.services.bedrockagentruntime.model.RetrieveAndGenerateRequest;
import com.amazonaws.services.bedrockagentruntime.model.RetrieveAndGenerateResult;
import com.amazonaws.services.bedrockagentruntime.model.RetrieveRequest;
import com.amazonaws.services.bedrockagentruntime.model.RetrieveResult;
import com.amazonaws.services.bedrockagentruntime.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.BadGatewayExceptionUnmarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.DeleteAgentMemoryRequestProtocolMarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.DeleteAgentMemoryResultJsonUnmarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.DependencyFailedExceptionUnmarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.GetAgentMemoryRequestProtocolMarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.GetAgentMemoryResultJsonUnmarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.RetrieveAndGenerateRequestProtocolMarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.RetrieveAndGenerateResultJsonUnmarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.RetrieveRequestProtocolMarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.RetrieveResultJsonUnmarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.bedrockagentruntime.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSBedrockAgentRuntimeClient
extends AmazonWebServiceClient
implements AWSBedrockAgentRuntime {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSBedrockAgentRuntime.class);
    private static final String DEFAULT_SIGNING_NAME = "bedrock";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DependencyFailedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DependencyFailedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadGatewayException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadGatewayExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSBedrockAgentRuntimeException.class));

    public static AWSBedrockAgentRuntimeClientBuilder builder() {
        return AWSBedrockAgentRuntimeClientBuilder.standard();
    }

    AWSBedrockAgentRuntimeClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSBedrockAgentRuntimeClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("bedrock-agent-runtime");
        this.setEndpoint("bedrock-agent-runtime.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/bedrockagentruntime/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/bedrockagentruntime/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DeleteAgentMemoryResult deleteAgentMemory(DeleteAgentMemoryRequest request) {
        request = (DeleteAgentMemoryRequest)this.beforeClientExecution(request);
        return this.executeDeleteAgentMemory(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAgentMemoryResult executeDeleteAgentMemory(DeleteAgentMemoryRequest deleteAgentMemoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAgentMemoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAgentMemoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAgentMemoryRequestProtocolMarshaller(protocolFactory).marshall((DeleteAgentMemoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAgentMemoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock Agent Runtime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAgentMemory");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAgentMemoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAgentMemoryResult deleteAgentMemoryResult = (DeleteAgentMemoryResult)response.getAwsResponse();
            return deleteAgentMemoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAgentMemoryResult getAgentMemory(GetAgentMemoryRequest request) {
        request = (GetAgentMemoryRequest)this.beforeClientExecution(request);
        return this.executeGetAgentMemory(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAgentMemoryResult executeGetAgentMemory(GetAgentMemoryRequest getAgentMemoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAgentMemoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAgentMemoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAgentMemoryRequestProtocolMarshaller(protocolFactory).marshall((GetAgentMemoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAgentMemoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock Agent Runtime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAgentMemory");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAgentMemoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAgentMemoryResult getAgentMemoryResult = (GetAgentMemoryResult)response.getAwsResponse();
            return getAgentMemoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RetrieveResult retrieve(RetrieveRequest request) {
        request = (RetrieveRequest)this.beforeClientExecution(request);
        return this.executeRetrieve(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RetrieveResult executeRetrieve(RetrieveRequest retrieveRequest) {
        ExecutionContext executionContext = this.createExecutionContext(retrieveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RetrieveRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RetrieveRequestProtocolMarshaller(protocolFactory).marshall((RetrieveRequest)super.beforeMarshalling((AmazonWebServiceRequest)retrieveRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock Agent Runtime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"Retrieve");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RetrieveResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RetrieveResult retrieveResult = (RetrieveResult)response.getAwsResponse();
            return retrieveResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RetrieveAndGenerateResult retrieveAndGenerate(RetrieveAndGenerateRequest request) {
        request = (RetrieveAndGenerateRequest)this.beforeClientExecution(request);
        return this.executeRetrieveAndGenerate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RetrieveAndGenerateResult executeRetrieveAndGenerate(RetrieveAndGenerateRequest retrieveAndGenerateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(retrieveAndGenerateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RetrieveAndGenerateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RetrieveAndGenerateRequestProtocolMarshaller(protocolFactory).marshall((RetrieveAndGenerateRequest)super.beforeMarshalling((AmazonWebServiceRequest)retrieveAndGenerateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Bedrock Agent Runtime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RetrieveAndGenerate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RetrieveAndGenerateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RetrieveAndGenerateResult retrieveAndGenerateResult = (RetrieveAndGenerateResult)response.getAwsResponse();
            return retrieveAndGenerateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

