/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagentruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagentruntime.model.transform.TextInferenceConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TextInferenceConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer maxTokens;
    private List<String> stopSequences;
    private Float temperature;
    private Float topP;

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public TextInferenceConfig withMaxTokens(Integer maxTokens) {
        this.setMaxTokens(maxTokens);
        return this;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(Collection<String> stopSequences) {
        if (stopSequences == null) {
            this.stopSequences = null;
            return;
        }
        this.stopSequences = new ArrayList<String>(stopSequences);
    }

    public TextInferenceConfig withStopSequences(String ... stopSequences) {
        if (this.stopSequences == null) {
            this.setStopSequences(new ArrayList<String>(stopSequences.length));
        }
        for (String ele : stopSequences) {
            this.stopSequences.add(ele);
        }
        return this;
    }

    public TextInferenceConfig withStopSequences(Collection<String> stopSequences) {
        this.setStopSequences(stopSequences);
        return this;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public TextInferenceConfig withTemperature(Float temperature) {
        this.setTemperature(temperature);
        return this;
    }

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public Float getTopP() {
        return this.topP;
    }

    public TextInferenceConfig withTopP(Float topP) {
        this.setTopP(topP);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMaxTokens() != null) {
            sb.append("MaxTokens: ").append(this.getMaxTokens()).append(",");
        }
        if (this.getStopSequences() != null) {
            sb.append("StopSequences: ").append(this.getStopSequences()).append(",");
        }
        if (this.getTemperature() != null) {
            sb.append("Temperature: ").append(this.getTemperature()).append(",");
        }
        if (this.getTopP() != null) {
            sb.append("TopP: ").append(this.getTopP());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextInferenceConfig)) {
            return false;
        }
        TextInferenceConfig other = (TextInferenceConfig)obj;
        if (other.getMaxTokens() == null ^ this.getMaxTokens() == null) {
            return false;
        }
        if (other.getMaxTokens() != null && !other.getMaxTokens().equals(this.getMaxTokens())) {
            return false;
        }
        if (other.getStopSequences() == null ^ this.getStopSequences() == null) {
            return false;
        }
        if (other.getStopSequences() != null && !other.getStopSequences().equals(this.getStopSequences())) {
            return false;
        }
        if (other.getTemperature() == null ^ this.getTemperature() == null) {
            return false;
        }
        if (other.getTemperature() != null && !other.getTemperature().equals(this.getTemperature())) {
            return false;
        }
        if (other.getTopP() == null ^ this.getTopP() == null) {
            return false;
        }
        return other.getTopP() == null || other.getTopP().equals(this.getTopP());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMaxTokens() == null ? 0 : this.getMaxTokens().hashCode());
        hashCode = 31 * hashCode + (this.getStopSequences() == null ? 0 : this.getStopSequences().hashCode());
        hashCode = 31 * hashCode + (this.getTemperature() == null ? 0 : this.getTemperature().hashCode());
        hashCode = 31 * hashCode + (this.getTopP() == null ? 0 : this.getTopP().hashCode());
        return hashCode;
    }

    public TextInferenceConfig clone() {
        try {
            return (TextInferenceConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TextInferenceConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

