/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagent.model.IngestionJobStatistics;
import com.amazonaws.services.bedrockagent.model.IngestionJobStatus;
import com.amazonaws.services.bedrockagent.model.transform.IngestionJobMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class IngestionJob
implements Serializable,
Cloneable,
StructuredPojo {
    private String dataSourceId;
    private String description;
    private List<String> failureReasons;
    private String ingestionJobId;
    private String knowledgeBaseId;
    private Date startedAt;
    private IngestionJobStatistics statistics;
    private String status;
    private Date updatedAt;

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public IngestionJob withDataSourceId(String dataSourceId) {
        this.setDataSourceId(dataSourceId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public IngestionJob withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getFailureReasons() {
        return this.failureReasons;
    }

    public void setFailureReasons(Collection<String> failureReasons) {
        if (failureReasons == null) {
            this.failureReasons = null;
            return;
        }
        this.failureReasons = new ArrayList<String>(failureReasons);
    }

    public IngestionJob withFailureReasons(String ... failureReasons) {
        if (this.failureReasons == null) {
            this.setFailureReasons(new ArrayList<String>(failureReasons.length));
        }
        for (String ele : failureReasons) {
            this.failureReasons.add(ele);
        }
        return this;
    }

    public IngestionJob withFailureReasons(Collection<String> failureReasons) {
        this.setFailureReasons(failureReasons);
        return this;
    }

    public void setIngestionJobId(String ingestionJobId) {
        this.ingestionJobId = ingestionJobId;
    }

    public String getIngestionJobId() {
        return this.ingestionJobId;
    }

    public IngestionJob withIngestionJobId(String ingestionJobId) {
        this.setIngestionJobId(ingestionJobId);
        return this;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public IngestionJob withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public IngestionJob withStartedAt(Date startedAt) {
        this.setStartedAt(startedAt);
        return this;
    }

    public void setStatistics(IngestionJobStatistics statistics) {
        this.statistics = statistics;
    }

    public IngestionJobStatistics getStatistics() {
        return this.statistics;
    }

    public IngestionJob withStatistics(IngestionJobStatistics statistics) {
        this.setStatistics(statistics);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public IngestionJob withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public IngestionJob withStatus(IngestionJobStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public IngestionJob withUpdatedAt(Date updatedAt) {
        this.setUpdatedAt(updatedAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSourceId() != null) {
            sb.append("DataSourceId: ").append(this.getDataSourceId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getFailureReasons() != null) {
            sb.append("FailureReasons: ").append(this.getFailureReasons()).append(",");
        }
        if (this.getIngestionJobId() != null) {
            sb.append("IngestionJobId: ").append(this.getIngestionJobId()).append(",");
        }
        if (this.getKnowledgeBaseId() != null) {
            sb.append("KnowledgeBaseId: ").append(this.getKnowledgeBaseId()).append(",");
        }
        if (this.getStartedAt() != null) {
            sb.append("StartedAt: ").append(this.getStartedAt()).append(",");
        }
        if (this.getStatistics() != null) {
            sb.append("Statistics: ").append(this.getStatistics()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getUpdatedAt() != null) {
            sb.append("UpdatedAt: ").append(this.getUpdatedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestionJob)) {
            return false;
        }
        IngestionJob other = (IngestionJob)obj;
        if (other.getDataSourceId() == null ^ this.getDataSourceId() == null) {
            return false;
        }
        if (other.getDataSourceId() != null && !other.getDataSourceId().equals(this.getDataSourceId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getFailureReasons() == null ^ this.getFailureReasons() == null) {
            return false;
        }
        if (other.getFailureReasons() != null && !other.getFailureReasons().equals(this.getFailureReasons())) {
            return false;
        }
        if (other.getIngestionJobId() == null ^ this.getIngestionJobId() == null) {
            return false;
        }
        if (other.getIngestionJobId() != null && !other.getIngestionJobId().equals(this.getIngestionJobId())) {
            return false;
        }
        if (other.getKnowledgeBaseId() == null ^ this.getKnowledgeBaseId() == null) {
            return false;
        }
        if (other.getKnowledgeBaseId() != null && !other.getKnowledgeBaseId().equals(this.getKnowledgeBaseId())) {
            return false;
        }
        if (other.getStartedAt() == null ^ this.getStartedAt() == null) {
            return false;
        }
        if (other.getStartedAt() != null && !other.getStartedAt().equals(this.getStartedAt())) {
            return false;
        }
        if (other.getStatistics() == null ^ this.getStatistics() == null) {
            return false;
        }
        if (other.getStatistics() != null && !other.getStatistics().equals(this.getStatistics())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null) {
            return false;
        }
        return other.getUpdatedAt() == null || other.getUpdatedAt().equals(this.getUpdatedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSourceId() == null ? 0 : this.getDataSourceId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getFailureReasons() == null ? 0 : this.getFailureReasons().hashCode());
        hashCode = 31 * hashCode + (this.getIngestionJobId() == null ? 0 : this.getIngestionJobId().hashCode());
        hashCode = 31 * hashCode + (this.getKnowledgeBaseId() == null ? 0 : this.getKnowledgeBaseId().hashCode());
        hashCode = 31 * hashCode + (this.getStartedAt() == null ? 0 : this.getStartedAt().hashCode());
        hashCode = 31 * hashCode + (this.getStatistics() == null ? 0 : this.getStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getUpdatedAt() == null ? 0 : this.getUpdatedAt().hashCode());
        return hashCode;
    }

    public IngestionJob clone() {
        try {
            return (IngestionJob)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IngestionJobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

