/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagent.model.IntermediateStorage;
import com.amazonaws.services.bedrockagent.model.Transformation;
import com.amazonaws.services.bedrockagent.model.transform.CustomTransformationConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CustomTransformationConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private IntermediateStorage intermediateStorage;
    private List<Transformation> transformations;

    public void setIntermediateStorage(IntermediateStorage intermediateStorage) {
        this.intermediateStorage = intermediateStorage;
    }

    public IntermediateStorage getIntermediateStorage() {
        return this.intermediateStorage;
    }

    public CustomTransformationConfiguration withIntermediateStorage(IntermediateStorage intermediateStorage) {
        this.setIntermediateStorage(intermediateStorage);
        return this;
    }

    public List<Transformation> getTransformations() {
        return this.transformations;
    }

    public void setTransformations(Collection<Transformation> transformations) {
        if (transformations == null) {
            this.transformations = null;
            return;
        }
        this.transformations = new ArrayList<Transformation>(transformations);
    }

    public CustomTransformationConfiguration withTransformations(Transformation ... transformations) {
        if (this.transformations == null) {
            this.setTransformations(new ArrayList<Transformation>(transformations.length));
        }
        for (Transformation ele : transformations) {
            this.transformations.add(ele);
        }
        return this;
    }

    public CustomTransformationConfiguration withTransformations(Collection<Transformation> transformations) {
        this.setTransformations(transformations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIntermediateStorage() != null) {
            sb.append("IntermediateStorage: ").append(this.getIntermediateStorage()).append(",");
        }
        if (this.getTransformations() != null) {
            sb.append("Transformations: ").append(this.getTransformations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomTransformationConfiguration)) {
            return false;
        }
        CustomTransformationConfiguration other = (CustomTransformationConfiguration)obj;
        if (other.getIntermediateStorage() == null ^ this.getIntermediateStorage() == null) {
            return false;
        }
        if (other.getIntermediateStorage() != null && !other.getIntermediateStorage().equals(this.getIntermediateStorage())) {
            return false;
        }
        if (other.getTransformations() == null ^ this.getTransformations() == null) {
            return false;
        }
        return other.getTransformations() == null || other.getTransformations().equals(this.getTransformations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIntermediateStorage() == null ? 0 : this.getIntermediateStorage().hashCode());
        hashCode = 31 * hashCode + (this.getTransformations() == null ? 0 : this.getTransformations().hashCode());
        return hashCode;
    }

    public CustomTransformationConfiguration clone() {
        try {
            return (CustomTransformationConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomTransformationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

