/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagent.model.SharePointAuthType;
import com.amazonaws.services.bedrockagent.model.SharePointHostType;
import com.amazonaws.services.bedrockagent.model.transform.SharePointSourceConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SharePointSourceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String authType;
    private String credentialsSecretArn;
    private String domain;
    private String hostType;
    private List<String> siteUrls;
    private String tenantId;

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getAuthType() {
        return this.authType;
    }

    public SharePointSourceConfiguration withAuthType(String authType) {
        this.setAuthType(authType);
        return this;
    }

    public SharePointSourceConfiguration withAuthType(SharePointAuthType authType) {
        this.authType = authType.toString();
        return this;
    }

    public void setCredentialsSecretArn(String credentialsSecretArn) {
        this.credentialsSecretArn = credentialsSecretArn;
    }

    public String getCredentialsSecretArn() {
        return this.credentialsSecretArn;
    }

    public SharePointSourceConfiguration withCredentialsSecretArn(String credentialsSecretArn) {
        this.setCredentialsSecretArn(credentialsSecretArn);
        return this;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public SharePointSourceConfiguration withDomain(String domain) {
        this.setDomain(domain);
        return this;
    }

    public void setHostType(String hostType) {
        this.hostType = hostType;
    }

    public String getHostType() {
        return this.hostType;
    }

    public SharePointSourceConfiguration withHostType(String hostType) {
        this.setHostType(hostType);
        return this;
    }

    public SharePointSourceConfiguration withHostType(SharePointHostType hostType) {
        this.hostType = hostType.toString();
        return this;
    }

    public List<String> getSiteUrls() {
        return this.siteUrls;
    }

    public void setSiteUrls(Collection<String> siteUrls) {
        if (siteUrls == null) {
            this.siteUrls = null;
            return;
        }
        this.siteUrls = new ArrayList<String>(siteUrls);
    }

    public SharePointSourceConfiguration withSiteUrls(String ... siteUrls) {
        if (this.siteUrls == null) {
            this.setSiteUrls(new ArrayList<String>(siteUrls.length));
        }
        for (String ele : siteUrls) {
            this.siteUrls.add(ele);
        }
        return this;
    }

    public SharePointSourceConfiguration withSiteUrls(Collection<String> siteUrls) {
        this.setSiteUrls(siteUrls);
        return this;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public SharePointSourceConfiguration withTenantId(String tenantId) {
        this.setTenantId(tenantId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthType() != null) {
            sb.append("AuthType: ").append(this.getAuthType()).append(",");
        }
        if (this.getCredentialsSecretArn() != null) {
            sb.append("CredentialsSecretArn: ").append(this.getCredentialsSecretArn()).append(",");
        }
        if (this.getDomain() != null) {
            sb.append("Domain: ").append(this.getDomain()).append(",");
        }
        if (this.getHostType() != null) {
            sb.append("HostType: ").append(this.getHostType()).append(",");
        }
        if (this.getSiteUrls() != null) {
            sb.append("SiteUrls: ").append(this.getSiteUrls()).append(",");
        }
        if (this.getTenantId() != null) {
            sb.append("TenantId: ").append(this.getTenantId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharePointSourceConfiguration)) {
            return false;
        }
        SharePointSourceConfiguration other = (SharePointSourceConfiguration)obj;
        if (other.getAuthType() == null ^ this.getAuthType() == null) {
            return false;
        }
        if (other.getAuthType() != null && !other.getAuthType().equals(this.getAuthType())) {
            return false;
        }
        if (other.getCredentialsSecretArn() == null ^ this.getCredentialsSecretArn() == null) {
            return false;
        }
        if (other.getCredentialsSecretArn() != null && !other.getCredentialsSecretArn().equals(this.getCredentialsSecretArn())) {
            return false;
        }
        if (other.getDomain() == null ^ this.getDomain() == null) {
            return false;
        }
        if (other.getDomain() != null && !other.getDomain().equals(this.getDomain())) {
            return false;
        }
        if (other.getHostType() == null ^ this.getHostType() == null) {
            return false;
        }
        if (other.getHostType() != null && !other.getHostType().equals(this.getHostType())) {
            return false;
        }
        if (other.getSiteUrls() == null ^ this.getSiteUrls() == null) {
            return false;
        }
        if (other.getSiteUrls() != null && !other.getSiteUrls().equals(this.getSiteUrls())) {
            return false;
        }
        if (other.getTenantId() == null ^ this.getTenantId() == null) {
            return false;
        }
        return other.getTenantId() == null || other.getTenantId().equals(this.getTenantId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthType() == null ? 0 : this.getAuthType().hashCode());
        hashCode = 31 * hashCode + (this.getCredentialsSecretArn() == null ? 0 : this.getCredentialsSecretArn().hashCode());
        hashCode = 31 * hashCode + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        hashCode = 31 * hashCode + (this.getHostType() == null ? 0 : this.getHostType().hashCode());
        hashCode = 31 * hashCode + (this.getSiteUrls() == null ? 0 : this.getSiteUrls().hashCode());
        hashCode = 31 * hashCode + (this.getTenantId() == null ? 0 : this.getTenantId().hashCode());
        return hashCode;
    }

    public SharePointSourceConfiguration clone() {
        try {
            return (SharePointSourceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SharePointSourceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

