/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagent.model.FlowConnection;
import com.amazonaws.services.bedrockagent.model.FlowNode;
import com.amazonaws.services.bedrockagent.model.transform.FlowDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FlowDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private List<FlowConnection> connections;
    private List<FlowNode> nodes;

    public List<FlowConnection> getConnections() {
        return this.connections;
    }

    public void setConnections(Collection<FlowConnection> connections) {
        if (connections == null) {
            this.connections = null;
            return;
        }
        this.connections = new ArrayList<FlowConnection>(connections);
    }

    public FlowDefinition withConnections(FlowConnection ... connections) {
        if (this.connections == null) {
            this.setConnections(new ArrayList<FlowConnection>(connections.length));
        }
        for (FlowConnection ele : connections) {
            this.connections.add(ele);
        }
        return this;
    }

    public FlowDefinition withConnections(Collection<FlowConnection> connections) {
        this.setConnections(connections);
        return this;
    }

    public List<FlowNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(Collection<FlowNode> nodes) {
        if (nodes == null) {
            this.nodes = null;
            return;
        }
        this.nodes = new ArrayList<FlowNode>(nodes);
    }

    public FlowDefinition withNodes(FlowNode ... nodes) {
        if (this.nodes == null) {
            this.setNodes(new ArrayList<FlowNode>(nodes.length));
        }
        for (FlowNode ele : nodes) {
            this.nodes.add(ele);
        }
        return this;
    }

    public FlowDefinition withNodes(Collection<FlowNode> nodes) {
        this.setNodes(nodes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConnections() != null) {
            sb.append("Connections: ").append(this.getConnections()).append(",");
        }
        if (this.getNodes() != null) {
            sb.append("Nodes: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowDefinition)) {
            return false;
        }
        FlowDefinition other = (FlowDefinition)obj;
        if (other.getConnections() == null ^ this.getConnections() == null) {
            return false;
        }
        if (other.getConnections() != null && !other.getConnections().equals(this.getConnections())) {
            return false;
        }
        if (other.getNodes() == null ^ this.getNodes() == null) {
            return false;
        }
        return other.getNodes() == null || other.getNodes().equals(this.getNodes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConnections() == null ? 0 : this.getConnections().hashCode());
        hashCode = 31 * hashCode + (this.getNodes() == null ? 0 : this.getNodes().hashCode());
        return hashCode;
    }

    public FlowDefinition clone() {
        try {
            return (FlowDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FlowDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

