/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagent.model.AgentVersion;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class AgentVersionMarshaller {
    private static final MarshallingInfo<String> AGENTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("agentArn").build();
    private static final MarshallingInfo<String> AGENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("agentId").build();
    private static final MarshallingInfo<String> AGENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("agentName").build();
    private static final MarshallingInfo<String> AGENTRESOURCEROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("agentResourceRoleArn").build();
    private static final MarshallingInfo<String> AGENTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("agentStatus").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> CUSTOMERENCRYPTIONKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerEncryptionKeyArn").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<List> FAILUREREASONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failureReasons").build();
    private static final MarshallingInfo<String> FOUNDATIONMODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("foundationModel").build();
    private static final MarshallingInfo<StructuredPojo> GUARDRAILCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("guardrailConfiguration").build();
    private static final MarshallingInfo<Integer> IDLESESSIONTTLINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("idleSessionTTLInSeconds").build();
    private static final MarshallingInfo<String> INSTRUCTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instruction").build();
    private static final MarshallingInfo<StructuredPojo> MEMORYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memoryConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> PROMPTOVERRIDECONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("promptOverrideConfiguration").build();
    private static final MarshallingInfo<List> RECOMMENDEDACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recommendedActions").build();
    private static final MarshallingInfo<Date> UPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updatedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final AgentVersionMarshaller instance = new AgentVersionMarshaller();

    public static AgentVersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(AgentVersion agentVersion, ProtocolMarshaller protocolMarshaller) {
        if (agentVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)agentVersion.getAgentArn(), AGENTARN_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getAgentId(), AGENTID_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getAgentName(), AGENTNAME_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getAgentResourceRoleArn(), AGENTRESOURCEROLEARN_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getAgentStatus(), AGENTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getCustomerEncryptionKeyArn(), CUSTOMERENCRYPTIONKEYARN_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(agentVersion.getFailureReasons(), FAILUREREASONS_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getFoundationModel(), FOUNDATIONMODEL_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getGuardrailConfiguration(), GUARDRAILCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getIdleSessionTTLInSeconds(), IDLESESSIONTTLINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getInstruction(), INSTRUCTION_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getMemoryConfiguration(), MEMORYCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getPromptOverrideConfiguration(), PROMPTOVERRIDECONFIGURATION_BINDING);
            protocolMarshaller.marshall(agentVersion.getRecommendedActions(), RECOMMENDEDACTIONS_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getUpdatedAt(), UPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.getVersion(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

