/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagent.model.transform.S3IdentifierMarshaller;
import java.io.Serializable;

public class S3Identifier
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3BucketName;
    private String s3ObjectKey;

    public void setS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public S3Identifier withS3BucketName(String s3BucketName) {
        this.setS3BucketName(s3BucketName);
        return this;
    }

    public void setS3ObjectKey(String s3ObjectKey) {
        this.s3ObjectKey = s3ObjectKey;
    }

    public String getS3ObjectKey() {
        return this.s3ObjectKey;
    }

    public S3Identifier withS3ObjectKey(String s3ObjectKey) {
        this.setS3ObjectKey(s3ObjectKey);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3BucketName() != null) {
            sb.append("S3BucketName: ").append(this.getS3BucketName()).append(",");
        }
        if (this.getS3ObjectKey() != null) {
            sb.append("S3ObjectKey: ").append(this.getS3ObjectKey());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Identifier)) {
            return false;
        }
        S3Identifier other = (S3Identifier)obj;
        if (other.getS3BucketName() == null ^ this.getS3BucketName() == null) {
            return false;
        }
        if (other.getS3BucketName() != null && !other.getS3BucketName().equals(this.getS3BucketName())) {
            return false;
        }
        if (other.getS3ObjectKey() == null ^ this.getS3ObjectKey() == null) {
            return false;
        }
        return other.getS3ObjectKey() == null || other.getS3ObjectKey().equals(this.getS3ObjectKey());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3BucketName() == null ? 0 : this.getS3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.getS3ObjectKey() == null ? 0 : this.getS3ObjectKey().hashCode());
        return hashCode;
    }

    public S3Identifier clone() {
        try {
            return (S3Identifier)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3IdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

