/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.bedrockagent.model.S3Identifier;

@SdkInternalApi
public class S3IdentifierMarshaller {
    private static final MarshallingInfo<String> S3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3BucketName").build();
    private static final MarshallingInfo<String> S3OBJECTKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3ObjectKey").build();
    private static final S3IdentifierMarshaller instance = new S3IdentifierMarshaller();

    public static S3IdentifierMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Identifier s3Identifier, ProtocolMarshaller protocolMarshaller) {
        if (s3Identifier == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Identifier.getS3BucketName(), S3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3Identifier.getS3ObjectKey(), S3OBJECTKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

