/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagent.model.S3Identifier;
import com.amazonaws.services.bedrockagent.model.transform.APISchemaMarshaller;
import java.io.Serializable;

public class APISchema
implements Serializable,
Cloneable,
StructuredPojo {
    private S3Identifier s3;
    private String payload;

    public void setS3(S3Identifier s3) {
        this.s3 = s3;
    }

    public S3Identifier getS3() {
        return this.s3;
    }

    public APISchema withS3(S3Identifier s3) {
        this.setS3(s3);
        return this;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String getPayload() {
        return this.payload;
    }

    public APISchema withPayload(String payload) {
        this.setPayload(payload);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3() != null) {
            sb.append("S3: ").append(this.getS3()).append(",");
        }
        if (this.getPayload() != null) {
            sb.append("Payload: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APISchema)) {
            return false;
        }
        APISchema other = (APISchema)obj;
        if (other.getS3() == null ^ this.getS3() == null) {
            return false;
        }
        if (other.getS3() != null && !other.getS3().equals(this.getS3())) {
            return false;
        }
        if (other.getPayload() == null ^ this.getPayload() == null) {
            return false;
        }
        return other.getPayload() == null || other.getPayload().equals(this.getPayload());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3() == null ? 0 : this.getS3().hashCode());
        hashCode = 31 * hashCode + (this.getPayload() == null ? 0 : this.getPayload().hashCode());
        return hashCode;
    }

    public APISchema clone() {
        try {
            return (APISchema)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        APISchemaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

