/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrock.model.GuardrailPiiEntity;
import com.amazonaws.services.bedrock.model.GuardrailRegex;
import com.amazonaws.services.bedrock.model.transform.GuardrailSensitiveInformationPolicyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GuardrailSensitiveInformationPolicy
implements Serializable,
Cloneable,
StructuredPojo {
    private List<GuardrailPiiEntity> piiEntities;
    private List<GuardrailRegex> regexes;

    public List<GuardrailPiiEntity> getPiiEntities() {
        return this.piiEntities;
    }

    public void setPiiEntities(Collection<GuardrailPiiEntity> piiEntities) {
        if (piiEntities == null) {
            this.piiEntities = null;
            return;
        }
        this.piiEntities = new ArrayList<GuardrailPiiEntity>(piiEntities);
    }

    public GuardrailSensitiveInformationPolicy withPiiEntities(GuardrailPiiEntity ... piiEntities) {
        if (this.piiEntities == null) {
            this.setPiiEntities(new ArrayList<GuardrailPiiEntity>(piiEntities.length));
        }
        for (GuardrailPiiEntity ele : piiEntities) {
            this.piiEntities.add(ele);
        }
        return this;
    }

    public GuardrailSensitiveInformationPolicy withPiiEntities(Collection<GuardrailPiiEntity> piiEntities) {
        this.setPiiEntities(piiEntities);
        return this;
    }

    public List<GuardrailRegex> getRegexes() {
        return this.regexes;
    }

    public void setRegexes(Collection<GuardrailRegex> regexes) {
        if (regexes == null) {
            this.regexes = null;
            return;
        }
        this.regexes = new ArrayList<GuardrailRegex>(regexes);
    }

    public GuardrailSensitiveInformationPolicy withRegexes(GuardrailRegex ... regexes) {
        if (this.regexes == null) {
            this.setRegexes(new ArrayList<GuardrailRegex>(regexes.length));
        }
        for (GuardrailRegex ele : regexes) {
            this.regexes.add(ele);
        }
        return this;
    }

    public GuardrailSensitiveInformationPolicy withRegexes(Collection<GuardrailRegex> regexes) {
        this.setRegexes(regexes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPiiEntities() != null) {
            sb.append("PiiEntities: ").append(this.getPiiEntities()).append(",");
        }
        if (this.getRegexes() != null) {
            sb.append("Regexes: ").append(this.getRegexes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailSensitiveInformationPolicy)) {
            return false;
        }
        GuardrailSensitiveInformationPolicy other = (GuardrailSensitiveInformationPolicy)obj;
        if (other.getPiiEntities() == null ^ this.getPiiEntities() == null) {
            return false;
        }
        if (other.getPiiEntities() != null && !other.getPiiEntities().equals(this.getPiiEntities())) {
            return false;
        }
        if (other.getRegexes() == null ^ this.getRegexes() == null) {
            return false;
        }
        return other.getRegexes() == null || other.getRegexes().equals(this.getRegexes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPiiEntities() == null ? 0 : this.getPiiEntities().hashCode());
        hashCode = 31 * hashCode + (this.getRegexes() == null ? 0 : this.getRegexes().hashCode());
        return hashCode;
    }

    public GuardrailSensitiveInformationPolicy clone() {
        try {
            return (GuardrailSensitiveInformationPolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GuardrailSensitiveInformationPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

