/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrock.model.EvaluationDatasetMetricConfig;
import com.amazonaws.services.bedrock.model.HumanEvaluationCustomMetric;
import com.amazonaws.services.bedrock.model.HumanWorkflowConfig;
import com.amazonaws.services.bedrock.model.transform.HumanEvaluationConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HumanEvaluationConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private HumanWorkflowConfig humanWorkflowConfig;
    private List<HumanEvaluationCustomMetric> customMetrics;
    private List<EvaluationDatasetMetricConfig> datasetMetricConfigs;

    public void setHumanWorkflowConfig(HumanWorkflowConfig humanWorkflowConfig) {
        this.humanWorkflowConfig = humanWorkflowConfig;
    }

    public HumanWorkflowConfig getHumanWorkflowConfig() {
        return this.humanWorkflowConfig;
    }

    public HumanEvaluationConfig withHumanWorkflowConfig(HumanWorkflowConfig humanWorkflowConfig) {
        this.setHumanWorkflowConfig(humanWorkflowConfig);
        return this;
    }

    public List<HumanEvaluationCustomMetric> getCustomMetrics() {
        return this.customMetrics;
    }

    public void setCustomMetrics(Collection<HumanEvaluationCustomMetric> customMetrics) {
        if (customMetrics == null) {
            this.customMetrics = null;
            return;
        }
        this.customMetrics = new ArrayList<HumanEvaluationCustomMetric>(customMetrics);
    }

    public HumanEvaluationConfig withCustomMetrics(HumanEvaluationCustomMetric ... customMetrics) {
        if (this.customMetrics == null) {
            this.setCustomMetrics(new ArrayList<HumanEvaluationCustomMetric>(customMetrics.length));
        }
        for (HumanEvaluationCustomMetric ele : customMetrics) {
            this.customMetrics.add(ele);
        }
        return this;
    }

    public HumanEvaluationConfig withCustomMetrics(Collection<HumanEvaluationCustomMetric> customMetrics) {
        this.setCustomMetrics(customMetrics);
        return this;
    }

    public List<EvaluationDatasetMetricConfig> getDatasetMetricConfigs() {
        return this.datasetMetricConfigs;
    }

    public void setDatasetMetricConfigs(Collection<EvaluationDatasetMetricConfig> datasetMetricConfigs) {
        if (datasetMetricConfigs == null) {
            this.datasetMetricConfigs = null;
            return;
        }
        this.datasetMetricConfigs = new ArrayList<EvaluationDatasetMetricConfig>(datasetMetricConfigs);
    }

    public HumanEvaluationConfig withDatasetMetricConfigs(EvaluationDatasetMetricConfig ... datasetMetricConfigs) {
        if (this.datasetMetricConfigs == null) {
            this.setDatasetMetricConfigs(new ArrayList<EvaluationDatasetMetricConfig>(datasetMetricConfigs.length));
        }
        for (EvaluationDatasetMetricConfig ele : datasetMetricConfigs) {
            this.datasetMetricConfigs.add(ele);
        }
        return this;
    }

    public HumanEvaluationConfig withDatasetMetricConfigs(Collection<EvaluationDatasetMetricConfig> datasetMetricConfigs) {
        this.setDatasetMetricConfigs(datasetMetricConfigs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHumanWorkflowConfig() != null) {
            sb.append("HumanWorkflowConfig: ").append(this.getHumanWorkflowConfig()).append(",");
        }
        if (this.getCustomMetrics() != null) {
            sb.append("CustomMetrics: ").append(this.getCustomMetrics()).append(",");
        }
        if (this.getDatasetMetricConfigs() != null) {
            sb.append("DatasetMetricConfigs: ").append(this.getDatasetMetricConfigs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanEvaluationConfig)) {
            return false;
        }
        HumanEvaluationConfig other = (HumanEvaluationConfig)obj;
        if (other.getHumanWorkflowConfig() == null ^ this.getHumanWorkflowConfig() == null) {
            return false;
        }
        if (other.getHumanWorkflowConfig() != null && !other.getHumanWorkflowConfig().equals(this.getHumanWorkflowConfig())) {
            return false;
        }
        if (other.getCustomMetrics() == null ^ this.getCustomMetrics() == null) {
            return false;
        }
        if (other.getCustomMetrics() != null && !other.getCustomMetrics().equals(this.getCustomMetrics())) {
            return false;
        }
        if (other.getDatasetMetricConfigs() == null ^ this.getDatasetMetricConfigs() == null) {
            return false;
        }
        return other.getDatasetMetricConfigs() == null || other.getDatasetMetricConfigs().equals(this.getDatasetMetricConfigs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHumanWorkflowConfig() == null ? 0 : this.getHumanWorkflowConfig().hashCode());
        hashCode = 31 * hashCode + (this.getCustomMetrics() == null ? 0 : this.getCustomMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetMetricConfigs() == null ? 0 : this.getDatasetMetricConfigs().hashCode());
        return hashCode;
    }

    public HumanEvaluationConfig clone() {
        try {
            return (HumanEvaluationConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HumanEvaluationConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

