/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bcmdataexports.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bcmdataexports.model.transform.DataQueryMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DataQuery
implements Serializable,
Cloneable,
StructuredPojo {
    private String queryStatement;
    private Map<String, Map<String, String>> tableConfigurations;

    public void setQueryStatement(String queryStatement) {
        this.queryStatement = queryStatement;
    }

    public String getQueryStatement() {
        return this.queryStatement;
    }

    public DataQuery withQueryStatement(String queryStatement) {
        this.setQueryStatement(queryStatement);
        return this;
    }

    public Map<String, Map<String, String>> getTableConfigurations() {
        return this.tableConfigurations;
    }

    public void setTableConfigurations(Map<String, Map<String, String>> tableConfigurations) {
        this.tableConfigurations = tableConfigurations;
    }

    public DataQuery withTableConfigurations(Map<String, Map<String, String>> tableConfigurations) {
        this.setTableConfigurations(tableConfigurations);
        return this;
    }

    public DataQuery addTableConfigurationsEntry(String key, Map<String, String> value) {
        if (null == this.tableConfigurations) {
            this.tableConfigurations = new HashMap<String, Map<String, String>>();
        }
        if (this.tableConfigurations.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tableConfigurations.put(key, value);
        return this;
    }

    public DataQuery clearTableConfigurationsEntries() {
        this.tableConfigurations = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueryStatement() != null) {
            sb.append("QueryStatement: ").append(this.getQueryStatement()).append(",");
        }
        if (this.getTableConfigurations() != null) {
            sb.append("TableConfigurations: ").append(this.getTableConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQuery)) {
            return false;
        }
        DataQuery other = (DataQuery)obj;
        if (other.getQueryStatement() == null ^ this.getQueryStatement() == null) {
            return false;
        }
        if (other.getQueryStatement() != null && !other.getQueryStatement().equals(this.getQueryStatement())) {
            return false;
        }
        if (other.getTableConfigurations() == null ^ this.getTableConfigurations() == null) {
            return false;
        }
        return other.getTableConfigurations() == null || other.getTableConfigurations().equals(this.getTableConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueryStatement() == null ? 0 : this.getQueryStatement().hashCode());
        hashCode = 31 * hashCode + (this.getTableConfigurations() == null ? 0 : this.getTableConfigurations().hashCode());
        return hashCode;
    }

    public DataQuery clone() {
        try {
            return (DataQuery)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataQueryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

