/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.ContainerProperties;
import com.amazonaws.services.batch.model.EcsProperties;
import com.amazonaws.services.batch.model.EksProperties;
import com.amazonaws.services.batch.model.transform.NodeRangePropertyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodeRangeProperty
implements Serializable,
Cloneable,
StructuredPojo {
    private String targetNodes;
    private ContainerProperties container;
    private List<String> instanceTypes;
    private EcsProperties ecsProperties;
    private EksProperties eksProperties;

    public void setTargetNodes(String targetNodes) {
        this.targetNodes = targetNodes;
    }

    public String getTargetNodes() {
        return this.targetNodes;
    }

    public NodeRangeProperty withTargetNodes(String targetNodes) {
        this.setTargetNodes(targetNodes);
        return this;
    }

    public void setContainer(ContainerProperties container) {
        this.container = container;
    }

    public ContainerProperties getContainer() {
        return this.container;
    }

    public NodeRangeProperty withContainer(ContainerProperties container) {
        this.setContainer(container);
        return this;
    }

    public List<String> getInstanceTypes() {
        return this.instanceTypes;
    }

    public void setInstanceTypes(Collection<String> instanceTypes) {
        if (instanceTypes == null) {
            this.instanceTypes = null;
            return;
        }
        this.instanceTypes = new ArrayList<String>(instanceTypes);
    }

    public NodeRangeProperty withInstanceTypes(String ... instanceTypes) {
        if (this.instanceTypes == null) {
            this.setInstanceTypes(new ArrayList<String>(instanceTypes.length));
        }
        for (String ele : instanceTypes) {
            this.instanceTypes.add(ele);
        }
        return this;
    }

    public NodeRangeProperty withInstanceTypes(Collection<String> instanceTypes) {
        this.setInstanceTypes(instanceTypes);
        return this;
    }

    public void setEcsProperties(EcsProperties ecsProperties) {
        this.ecsProperties = ecsProperties;
    }

    public EcsProperties getEcsProperties() {
        return this.ecsProperties;
    }

    public NodeRangeProperty withEcsProperties(EcsProperties ecsProperties) {
        this.setEcsProperties(ecsProperties);
        return this;
    }

    public void setEksProperties(EksProperties eksProperties) {
        this.eksProperties = eksProperties;
    }

    public EksProperties getEksProperties() {
        return this.eksProperties;
    }

    public NodeRangeProperty withEksProperties(EksProperties eksProperties) {
        this.setEksProperties(eksProperties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargetNodes() != null) {
            sb.append("TargetNodes: ").append(this.getTargetNodes()).append(",");
        }
        if (this.getContainer() != null) {
            sb.append("Container: ").append(this.getContainer()).append(",");
        }
        if (this.getInstanceTypes() != null) {
            sb.append("InstanceTypes: ").append(this.getInstanceTypes()).append(",");
        }
        if (this.getEcsProperties() != null) {
            sb.append("EcsProperties: ").append(this.getEcsProperties()).append(",");
        }
        if (this.getEksProperties() != null) {
            sb.append("EksProperties: ").append(this.getEksProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeRangeProperty)) {
            return false;
        }
        NodeRangeProperty other = (NodeRangeProperty)obj;
        if (other.getTargetNodes() == null ^ this.getTargetNodes() == null) {
            return false;
        }
        if (other.getTargetNodes() != null && !other.getTargetNodes().equals(this.getTargetNodes())) {
            return false;
        }
        if (other.getContainer() == null ^ this.getContainer() == null) {
            return false;
        }
        if (other.getContainer() != null && !other.getContainer().equals(this.getContainer())) {
            return false;
        }
        if (other.getInstanceTypes() == null ^ this.getInstanceTypes() == null) {
            return false;
        }
        if (other.getInstanceTypes() != null && !other.getInstanceTypes().equals(this.getInstanceTypes())) {
            return false;
        }
        if (other.getEcsProperties() == null ^ this.getEcsProperties() == null) {
            return false;
        }
        if (other.getEcsProperties() != null && !other.getEcsProperties().equals(this.getEcsProperties())) {
            return false;
        }
        if (other.getEksProperties() == null ^ this.getEksProperties() == null) {
            return false;
        }
        return other.getEksProperties() == null || other.getEksProperties().equals(this.getEksProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargetNodes() == null ? 0 : this.getTargetNodes().hashCode());
        hashCode = 31 * hashCode + (this.getContainer() == null ? 0 : this.getContainer().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceTypes() == null ? 0 : this.getInstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getEcsProperties() == null ? 0 : this.getEcsProperties().hashCode());
        hashCode = 31 * hashCode + (this.getEksProperties() == null ? 0 : this.getEksProperties().hashCode());
        return hashCode;
    }

    public NodeRangeProperty clone() {
        try {
            return (NodeRangeProperty)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NodeRangePropertyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

