/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.Device;
import com.amazonaws.services.batch.model.Tmpfs;
import com.amazonaws.services.batch.model.transform.LinuxParametersMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LinuxParameters
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Device> devices;
    private Boolean initProcessEnabled;
    private Integer sharedMemorySize;
    private List<Tmpfs> tmpfs;
    private Integer maxSwap;
    private Integer swappiness;

    public List<Device> getDevices() {
        return this.devices;
    }

    public void setDevices(Collection<Device> devices) {
        if (devices == null) {
            this.devices = null;
            return;
        }
        this.devices = new ArrayList<Device>(devices);
    }

    public LinuxParameters withDevices(Device ... devices) {
        if (this.devices == null) {
            this.setDevices(new ArrayList<Device>(devices.length));
        }
        for (Device ele : devices) {
            this.devices.add(ele);
        }
        return this;
    }

    public LinuxParameters withDevices(Collection<Device> devices) {
        this.setDevices(devices);
        return this;
    }

    public void setInitProcessEnabled(Boolean initProcessEnabled) {
        this.initProcessEnabled = initProcessEnabled;
    }

    public Boolean getInitProcessEnabled() {
        return this.initProcessEnabled;
    }

    public LinuxParameters withInitProcessEnabled(Boolean initProcessEnabled) {
        this.setInitProcessEnabled(initProcessEnabled);
        return this;
    }

    public Boolean isInitProcessEnabled() {
        return this.initProcessEnabled;
    }

    public void setSharedMemorySize(Integer sharedMemorySize) {
        this.sharedMemorySize = sharedMemorySize;
    }

    public Integer getSharedMemorySize() {
        return this.sharedMemorySize;
    }

    public LinuxParameters withSharedMemorySize(Integer sharedMemorySize) {
        this.setSharedMemorySize(sharedMemorySize);
        return this;
    }

    public List<Tmpfs> getTmpfs() {
        return this.tmpfs;
    }

    public void setTmpfs(Collection<Tmpfs> tmpfs) {
        if (tmpfs == null) {
            this.tmpfs = null;
            return;
        }
        this.tmpfs = new ArrayList<Tmpfs>(tmpfs);
    }

    public LinuxParameters withTmpfs(Tmpfs ... tmpfs) {
        if (this.tmpfs == null) {
            this.setTmpfs(new ArrayList<Tmpfs>(tmpfs.length));
        }
        for (Tmpfs ele : tmpfs) {
            this.tmpfs.add(ele);
        }
        return this;
    }

    public LinuxParameters withTmpfs(Collection<Tmpfs> tmpfs) {
        this.setTmpfs(tmpfs);
        return this;
    }

    public void setMaxSwap(Integer maxSwap) {
        this.maxSwap = maxSwap;
    }

    public Integer getMaxSwap() {
        return this.maxSwap;
    }

    public LinuxParameters withMaxSwap(Integer maxSwap) {
        this.setMaxSwap(maxSwap);
        return this;
    }

    public void setSwappiness(Integer swappiness) {
        this.swappiness = swappiness;
    }

    public Integer getSwappiness() {
        return this.swappiness;
    }

    public LinuxParameters withSwappiness(Integer swappiness) {
        this.setSwappiness(swappiness);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDevices() != null) {
            sb.append("Devices: ").append(this.getDevices()).append(",");
        }
        if (this.getInitProcessEnabled() != null) {
            sb.append("InitProcessEnabled: ").append(this.getInitProcessEnabled()).append(",");
        }
        if (this.getSharedMemorySize() != null) {
            sb.append("SharedMemorySize: ").append(this.getSharedMemorySize()).append(",");
        }
        if (this.getTmpfs() != null) {
            sb.append("Tmpfs: ").append(this.getTmpfs()).append(",");
        }
        if (this.getMaxSwap() != null) {
            sb.append("MaxSwap: ").append(this.getMaxSwap()).append(",");
        }
        if (this.getSwappiness() != null) {
            sb.append("Swappiness: ").append(this.getSwappiness());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinuxParameters)) {
            return false;
        }
        LinuxParameters other = (LinuxParameters)obj;
        if (other.getDevices() == null ^ this.getDevices() == null) {
            return false;
        }
        if (other.getDevices() != null && !other.getDevices().equals(this.getDevices())) {
            return false;
        }
        if (other.getInitProcessEnabled() == null ^ this.getInitProcessEnabled() == null) {
            return false;
        }
        if (other.getInitProcessEnabled() != null && !other.getInitProcessEnabled().equals(this.getInitProcessEnabled())) {
            return false;
        }
        if (other.getSharedMemorySize() == null ^ this.getSharedMemorySize() == null) {
            return false;
        }
        if (other.getSharedMemorySize() != null && !other.getSharedMemorySize().equals(this.getSharedMemorySize())) {
            return false;
        }
        if (other.getTmpfs() == null ^ this.getTmpfs() == null) {
            return false;
        }
        if (other.getTmpfs() != null && !other.getTmpfs().equals(this.getTmpfs())) {
            return false;
        }
        if (other.getMaxSwap() == null ^ this.getMaxSwap() == null) {
            return false;
        }
        if (other.getMaxSwap() != null && !other.getMaxSwap().equals(this.getMaxSwap())) {
            return false;
        }
        if (other.getSwappiness() == null ^ this.getSwappiness() == null) {
            return false;
        }
        return other.getSwappiness() == null || other.getSwappiness().equals(this.getSwappiness());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDevices() == null ? 0 : this.getDevices().hashCode());
        hashCode = 31 * hashCode + (this.getInitProcessEnabled() == null ? 0 : this.getInitProcessEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getSharedMemorySize() == null ? 0 : this.getSharedMemorySize().hashCode());
        hashCode = 31 * hashCode + (this.getTmpfs() == null ? 0 : this.getTmpfs().hashCode());
        hashCode = 31 * hashCode + (this.getMaxSwap() == null ? 0 : this.getMaxSwap().hashCode());
        hashCode = 31 * hashCode + (this.getSwappiness() == null ? 0 : this.getSwappiness().hashCode());
        return hashCode;
    }

    public LinuxParameters clone() {
        try {
            return (LinuxParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LinuxParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

