/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.transform.TmpfsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Tmpfs
implements Serializable,
Cloneable,
StructuredPojo {
    private String containerPath;
    private Integer size;
    private List<String> mountOptions;

    public void setContainerPath(String containerPath) {
        this.containerPath = containerPath;
    }

    public String getContainerPath() {
        return this.containerPath;
    }

    public Tmpfs withContainerPath(String containerPath) {
        this.setContainerPath(containerPath);
        return this;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getSize() {
        return this.size;
    }

    public Tmpfs withSize(Integer size) {
        this.setSize(size);
        return this;
    }

    public List<String> getMountOptions() {
        return this.mountOptions;
    }

    public void setMountOptions(Collection<String> mountOptions) {
        if (mountOptions == null) {
            this.mountOptions = null;
            return;
        }
        this.mountOptions = new ArrayList<String>(mountOptions);
    }

    public Tmpfs withMountOptions(String ... mountOptions) {
        if (this.mountOptions == null) {
            this.setMountOptions(new ArrayList<String>(mountOptions.length));
        }
        for (String ele : mountOptions) {
            this.mountOptions.add(ele);
        }
        return this;
    }

    public Tmpfs withMountOptions(Collection<String> mountOptions) {
        this.setMountOptions(mountOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerPath() != null) {
            sb.append("ContainerPath: ").append(this.getContainerPath()).append(",");
        }
        if (this.getSize() != null) {
            sb.append("Size: ").append(this.getSize()).append(",");
        }
        if (this.getMountOptions() != null) {
            sb.append("MountOptions: ").append(this.getMountOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tmpfs)) {
            return false;
        }
        Tmpfs other = (Tmpfs)obj;
        if (other.getContainerPath() == null ^ this.getContainerPath() == null) {
            return false;
        }
        if (other.getContainerPath() != null && !other.getContainerPath().equals(this.getContainerPath())) {
            return false;
        }
        if (other.getSize() == null ^ this.getSize() == null) {
            return false;
        }
        if (other.getSize() != null && !other.getSize().equals(this.getSize())) {
            return false;
        }
        if (other.getMountOptions() == null ^ this.getMountOptions() == null) {
            return false;
        }
        return other.getMountOptions() == null || other.getMountOptions().equals(this.getMountOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerPath() == null ? 0 : this.getContainerPath().hashCode());
        hashCode = 31 * hashCode + (this.getSize() == null ? 0 : this.getSize().hashCode());
        hashCode = 31 * hashCode + (this.getMountOptions() == null ? 0 : this.getMountOptions().hashCode());
        return hashCode;
    }

    public Tmpfs clone() {
        try {
            return (Tmpfs)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TmpfsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

