/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.EphemeralStorage;
import com.amazonaws.services.batch.model.NetworkConfiguration;
import com.amazonaws.services.batch.model.RuntimePlatform;
import com.amazonaws.services.batch.model.TaskContainerProperties;
import com.amazonaws.services.batch.model.Volume;
import com.amazonaws.services.batch.model.transform.EcsTaskPropertiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EcsTaskProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private List<TaskContainerProperties> containers;
    private EphemeralStorage ephemeralStorage;
    private String executionRoleArn;
    private String platformVersion;
    private String ipcMode;
    private String taskRoleArn;
    private String pidMode;
    private NetworkConfiguration networkConfiguration;
    private RuntimePlatform runtimePlatform;
    private List<Volume> volumes;

    public List<TaskContainerProperties> getContainers() {
        return this.containers;
    }

    public void setContainers(Collection<TaskContainerProperties> containers) {
        if (containers == null) {
            this.containers = null;
            return;
        }
        this.containers = new ArrayList<TaskContainerProperties>(containers);
    }

    public EcsTaskProperties withContainers(TaskContainerProperties ... containers) {
        if (this.containers == null) {
            this.setContainers(new ArrayList<TaskContainerProperties>(containers.length));
        }
        for (TaskContainerProperties ele : containers) {
            this.containers.add(ele);
        }
        return this;
    }

    public EcsTaskProperties withContainers(Collection<TaskContainerProperties> containers) {
        this.setContainers(containers);
        return this;
    }

    public void setEphemeralStorage(EphemeralStorage ephemeralStorage) {
        this.ephemeralStorage = ephemeralStorage;
    }

    public EphemeralStorage getEphemeralStorage() {
        return this.ephemeralStorage;
    }

    public EcsTaskProperties withEphemeralStorage(EphemeralStorage ephemeralStorage) {
        this.setEphemeralStorage(ephemeralStorage);
        return this;
    }

    public void setExecutionRoleArn(String executionRoleArn) {
        this.executionRoleArn = executionRoleArn;
    }

    public String getExecutionRoleArn() {
        return this.executionRoleArn;
    }

    public EcsTaskProperties withExecutionRoleArn(String executionRoleArn) {
        this.setExecutionRoleArn(executionRoleArn);
        return this;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public EcsTaskProperties withPlatformVersion(String platformVersion) {
        this.setPlatformVersion(platformVersion);
        return this;
    }

    public void setIpcMode(String ipcMode) {
        this.ipcMode = ipcMode;
    }

    public String getIpcMode() {
        return this.ipcMode;
    }

    public EcsTaskProperties withIpcMode(String ipcMode) {
        this.setIpcMode(ipcMode);
        return this;
    }

    public void setTaskRoleArn(String taskRoleArn) {
        this.taskRoleArn = taskRoleArn;
    }

    public String getTaskRoleArn() {
        return this.taskRoleArn;
    }

    public EcsTaskProperties withTaskRoleArn(String taskRoleArn) {
        this.setTaskRoleArn(taskRoleArn);
        return this;
    }

    public void setPidMode(String pidMode) {
        this.pidMode = pidMode;
    }

    public String getPidMode() {
        return this.pidMode;
    }

    public EcsTaskProperties withPidMode(String pidMode) {
        this.setPidMode(pidMode);
        return this;
    }

    public void setNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public EcsTaskProperties withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.setNetworkConfiguration(networkConfiguration);
        return this;
    }

    public void setRuntimePlatform(RuntimePlatform runtimePlatform) {
        this.runtimePlatform = runtimePlatform;
    }

    public RuntimePlatform getRuntimePlatform() {
        return this.runtimePlatform;
    }

    public EcsTaskProperties withRuntimePlatform(RuntimePlatform runtimePlatform) {
        this.setRuntimePlatform(runtimePlatform);
        return this;
    }

    public List<Volume> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(Collection<Volume> volumes) {
        if (volumes == null) {
            this.volumes = null;
            return;
        }
        this.volumes = new ArrayList<Volume>(volumes);
    }

    public EcsTaskProperties withVolumes(Volume ... volumes) {
        if (this.volumes == null) {
            this.setVolumes(new ArrayList<Volume>(volumes.length));
        }
        for (Volume ele : volumes) {
            this.volumes.add(ele);
        }
        return this;
    }

    public EcsTaskProperties withVolumes(Collection<Volume> volumes) {
        this.setVolumes(volumes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainers() != null) {
            sb.append("Containers: ").append(this.getContainers()).append(",");
        }
        if (this.getEphemeralStorage() != null) {
            sb.append("EphemeralStorage: ").append(this.getEphemeralStorage()).append(",");
        }
        if (this.getExecutionRoleArn() != null) {
            sb.append("ExecutionRoleArn: ").append(this.getExecutionRoleArn()).append(",");
        }
        if (this.getPlatformVersion() != null) {
            sb.append("PlatformVersion: ").append(this.getPlatformVersion()).append(",");
        }
        if (this.getIpcMode() != null) {
            sb.append("IpcMode: ").append(this.getIpcMode()).append(",");
        }
        if (this.getTaskRoleArn() != null) {
            sb.append("TaskRoleArn: ").append(this.getTaskRoleArn()).append(",");
        }
        if (this.getPidMode() != null) {
            sb.append("PidMode: ").append(this.getPidMode()).append(",");
        }
        if (this.getNetworkConfiguration() != null) {
            sb.append("NetworkConfiguration: ").append(this.getNetworkConfiguration()).append(",");
        }
        if (this.getRuntimePlatform() != null) {
            sb.append("RuntimePlatform: ").append(this.getRuntimePlatform()).append(",");
        }
        if (this.getVolumes() != null) {
            sb.append("Volumes: ").append(this.getVolumes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsTaskProperties)) {
            return false;
        }
        EcsTaskProperties other = (EcsTaskProperties)obj;
        if (other.getContainers() == null ^ this.getContainers() == null) {
            return false;
        }
        if (other.getContainers() != null && !other.getContainers().equals(this.getContainers())) {
            return false;
        }
        if (other.getEphemeralStorage() == null ^ this.getEphemeralStorage() == null) {
            return false;
        }
        if (other.getEphemeralStorage() != null && !other.getEphemeralStorage().equals(this.getEphemeralStorage())) {
            return false;
        }
        if (other.getExecutionRoleArn() == null ^ this.getExecutionRoleArn() == null) {
            return false;
        }
        if (other.getExecutionRoleArn() != null && !other.getExecutionRoleArn().equals(this.getExecutionRoleArn())) {
            return false;
        }
        if (other.getPlatformVersion() == null ^ this.getPlatformVersion() == null) {
            return false;
        }
        if (other.getPlatformVersion() != null && !other.getPlatformVersion().equals(this.getPlatformVersion())) {
            return false;
        }
        if (other.getIpcMode() == null ^ this.getIpcMode() == null) {
            return false;
        }
        if (other.getIpcMode() != null && !other.getIpcMode().equals(this.getIpcMode())) {
            return false;
        }
        if (other.getTaskRoleArn() == null ^ this.getTaskRoleArn() == null) {
            return false;
        }
        if (other.getTaskRoleArn() != null && !other.getTaskRoleArn().equals(this.getTaskRoleArn())) {
            return false;
        }
        if (other.getPidMode() == null ^ this.getPidMode() == null) {
            return false;
        }
        if (other.getPidMode() != null && !other.getPidMode().equals(this.getPidMode())) {
            return false;
        }
        if (other.getNetworkConfiguration() == null ^ this.getNetworkConfiguration() == null) {
            return false;
        }
        if (other.getNetworkConfiguration() != null && !other.getNetworkConfiguration().equals(this.getNetworkConfiguration())) {
            return false;
        }
        if (other.getRuntimePlatform() == null ^ this.getRuntimePlatform() == null) {
            return false;
        }
        if (other.getRuntimePlatform() != null && !other.getRuntimePlatform().equals(this.getRuntimePlatform())) {
            return false;
        }
        if (other.getVolumes() == null ^ this.getVolumes() == null) {
            return false;
        }
        return other.getVolumes() == null || other.getVolumes().equals(this.getVolumes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainers() == null ? 0 : this.getContainers().hashCode());
        hashCode = 31 * hashCode + (this.getEphemeralStorage() == null ? 0 : this.getEphemeralStorage().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionRoleArn() == null ? 0 : this.getExecutionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformVersion() == null ? 0 : this.getPlatformVersion().hashCode());
        hashCode = 31 * hashCode + (this.getIpcMode() == null ? 0 : this.getIpcMode().hashCode());
        hashCode = 31 * hashCode + (this.getTaskRoleArn() == null ? 0 : this.getTaskRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getPidMode() == null ? 0 : this.getPidMode().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkConfiguration() == null ? 0 : this.getNetworkConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getRuntimePlatform() == null ? 0 : this.getRuntimePlatform().hashCode());
        hashCode = 31 * hashCode + (this.getVolumes() == null ? 0 : this.getVolumes().hashCode());
        return hashCode;
    }

    public EcsTaskProperties clone() {
        try {
            return (EcsTaskProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EcsTaskPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

