/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.ContainerProperties;
import java.util.List;

@SdkInternalApi
public class ContainerPropertiesMarshaller {
    private static final MarshallingInfo<String> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("image").build();
    private static final MarshallingInfo<Integer> VCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vcpus").build();
    private static final MarshallingInfo<Integer> MEMORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memory").build();
    private static final MarshallingInfo<List> COMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("command").build();
    private static final MarshallingInfo<String> JOBROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobRoleArn").build();
    private static final MarshallingInfo<String> EXECUTIONROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionRoleArn").build();
    private static final MarshallingInfo<List> VOLUMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("volumes").build();
    private static final MarshallingInfo<List> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environment").build();
    private static final MarshallingInfo<List> MOUNTPOINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mountPoints").build();
    private static final MarshallingInfo<Boolean> READONLYROOTFILESYSTEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("readonlyRootFilesystem").build();
    private static final MarshallingInfo<Boolean> PRIVILEGED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privileged").build();
    private static final MarshallingInfo<List> ULIMITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ulimits").build();
    private static final MarshallingInfo<String> USER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("user").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceType").build();
    private static final MarshallingInfo<List> RESOURCEREQUIREMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceRequirements").build();
    private static final MarshallingInfo<StructuredPojo> LINUXPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("linuxParameters").build();
    private static final MarshallingInfo<StructuredPojo> LOGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logConfiguration").build();
    private static final MarshallingInfo<List> SECRETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secrets").build();
    private static final MarshallingInfo<StructuredPojo> NETWORKCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> FARGATEPLATFORMCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fargatePlatformConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> EPHEMERALSTORAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ephemeralStorage").build();
    private static final MarshallingInfo<StructuredPojo> RUNTIMEPLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("runtimePlatform").build();
    private static final ContainerPropertiesMarshaller instance = new ContainerPropertiesMarshaller();

    public static ContainerPropertiesMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContainerProperties containerProperties, ProtocolMarshaller protocolMarshaller) {
        if (containerProperties == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)containerProperties.getImage(), IMAGE_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.getVcpus(), VCPUS_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.getMemory(), MEMORY_BINDING);
            protocolMarshaller.marshall(containerProperties.getCommand(), COMMAND_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.getJobRoleArn(), JOBROLEARN_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.getExecutionRoleArn(), EXECUTIONROLEARN_BINDING);
            protocolMarshaller.marshall(containerProperties.getVolumes(), VOLUMES_BINDING);
            protocolMarshaller.marshall(containerProperties.getEnvironment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall(containerProperties.getMountPoints(), MOUNTPOINTS_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.getReadonlyRootFilesystem(), READONLYROOTFILESYSTEM_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.getPrivileged(), PRIVILEGED_BINDING);
            protocolMarshaller.marshall(containerProperties.getUlimits(), ULIMITS_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.getUser(), USER_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.getInstanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall(containerProperties.getResourceRequirements(), RESOURCEREQUIREMENTS_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.getLinuxParameters(), LINUXPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.getLogConfiguration(), LOGCONFIGURATION_BINDING);
            protocolMarshaller.marshall(containerProperties.getSecrets(), SECRETS_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.getNetworkConfiguration(), NETWORKCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.getFargatePlatformConfiguration(), FARGATEPLATFORMCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.getEphemeralStorage(), EPHEMERALSTORAGE_BINDING);
            protocolMarshaller.marshall((Object)containerProperties.getRuntimePlatform(), RUNTIMEPLATFORM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

