/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupstorage.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.backupstorage.model.DataChecksumAlgorithm;
import java.io.InputStream;
import java.io.Serializable;

public class GetChunkResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private InputStream data;
    private Long length;
    private String checksum;
    private String checksumAlgorithm;

    public void setData(InputStream data) {
        this.data = data;
    }

    public InputStream getData() {
        return this.data;
    }

    public GetChunkResult withData(InputStream data) {
        this.setData(data);
        return this;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public Long getLength() {
        return this.length;
    }

    public GetChunkResult withLength(Long length) {
        this.setLength(length);
        return this;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public GetChunkResult withChecksum(String checksum) {
        this.setChecksum(checksum);
        return this;
    }

    public void setChecksumAlgorithm(String checksumAlgorithm) {
        this.checksumAlgorithm = checksumAlgorithm;
    }

    public String getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public GetChunkResult withChecksumAlgorithm(String checksumAlgorithm) {
        this.setChecksumAlgorithm(checksumAlgorithm);
        return this;
    }

    public GetChunkResult withChecksumAlgorithm(DataChecksumAlgorithm checksumAlgorithm) {
        this.checksumAlgorithm = checksumAlgorithm.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getData() != null) {
            sb.append("Data: ").append(this.getData()).append(",");
        }
        if (this.getLength() != null) {
            sb.append("Length: ").append(this.getLength()).append(",");
        }
        if (this.getChecksum() != null) {
            sb.append("Checksum: ").append(this.getChecksum()).append(",");
        }
        if (this.getChecksumAlgorithm() != null) {
            sb.append("ChecksumAlgorithm: ").append(this.getChecksumAlgorithm());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChunkResult)) {
            return false;
        }
        GetChunkResult other = (GetChunkResult)obj;
        if (other.getData() == null ^ this.getData() == null) {
            return false;
        }
        if (other.getData() != null && !other.getData().equals(this.getData())) {
            return false;
        }
        if (other.getLength() == null ^ this.getLength() == null) {
            return false;
        }
        if (other.getLength() != null && !other.getLength().equals(this.getLength())) {
            return false;
        }
        if (other.getChecksum() == null ^ this.getChecksum() == null) {
            return false;
        }
        if (other.getChecksum() != null && !other.getChecksum().equals(this.getChecksum())) {
            return false;
        }
        if (other.getChecksumAlgorithm() == null ^ this.getChecksumAlgorithm() == null) {
            return false;
        }
        return other.getChecksumAlgorithm() == null || other.getChecksumAlgorithm().equals(this.getChecksumAlgorithm());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getData() == null ? 0 : this.getData().hashCode());
        hashCode = 31 * hashCode + (this.getLength() == null ? 0 : this.getLength().hashCode());
        hashCode = 31 * hashCode + (this.getChecksum() == null ? 0 : this.getChecksum().hashCode());
        hashCode = 31 * hashCode + (this.getChecksumAlgorithm() == null ? 0 : this.getChecksumAlgorithm().hashCode());
        return hashCode;
    }

    public GetChunkResult clone() {
        try {
            return (GetChunkResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

