/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupgateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.VirtualMachine;
import java.util.Date;

@SdkInternalApi
public class VirtualMachineMarshaller {
    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HostName").build();
    private static final MarshallingInfo<String> HYPERVISORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HypervisorId").build();
    private static final MarshallingInfo<Date> LASTBACKUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastBackupDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Path").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").build();
    private static final VirtualMachineMarshaller instance = new VirtualMachineMarshaller();

    public static VirtualMachineMarshaller getInstance() {
        return instance;
    }

    public void marshall(VirtualMachine virtualMachine, ProtocolMarshaller protocolMarshaller) {
        if (virtualMachine == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)virtualMachine.getHostName(), HOSTNAME_BINDING);
            protocolMarshaller.marshall((Object)virtualMachine.getHypervisorId(), HYPERVISORID_BINDING);
            protocolMarshaller.marshall((Object)virtualMachine.getLastBackupDate(), LASTBACKUPDATE_BINDING);
            protocolMarshaller.marshall((Object)virtualMachine.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)virtualMachine.getPath(), PATH_BINDING);
            protocolMarshaller.marshall((Object)virtualMachine.getResourceArn(), RESOURCEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

