/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupgateway;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.backupgateway.AWSBackupGatewayAsync;
import com.amazonaws.services.backupgateway.AWSBackupGatewayAsyncClientBuilder;
import com.amazonaws.services.backupgateway.AWSBackupGatewayClient;
import com.amazonaws.services.backupgateway.model.AssociateGatewayToServerRequest;
import com.amazonaws.services.backupgateway.model.AssociateGatewayToServerResult;
import com.amazonaws.services.backupgateway.model.CreateGatewayRequest;
import com.amazonaws.services.backupgateway.model.CreateGatewayResult;
import com.amazonaws.services.backupgateway.model.DeleteGatewayRequest;
import com.amazonaws.services.backupgateway.model.DeleteGatewayResult;
import com.amazonaws.services.backupgateway.model.DeleteHypervisorRequest;
import com.amazonaws.services.backupgateway.model.DeleteHypervisorResult;
import com.amazonaws.services.backupgateway.model.DisassociateGatewayFromServerRequest;
import com.amazonaws.services.backupgateway.model.DisassociateGatewayFromServerResult;
import com.amazonaws.services.backupgateway.model.ImportHypervisorConfigurationRequest;
import com.amazonaws.services.backupgateway.model.ImportHypervisorConfigurationResult;
import com.amazonaws.services.backupgateway.model.ListGatewaysRequest;
import com.amazonaws.services.backupgateway.model.ListGatewaysResult;
import com.amazonaws.services.backupgateway.model.ListHypervisorsRequest;
import com.amazonaws.services.backupgateway.model.ListHypervisorsResult;
import com.amazonaws.services.backupgateway.model.ListTagsForResourceRequest;
import com.amazonaws.services.backupgateway.model.ListTagsForResourceResult;
import com.amazonaws.services.backupgateway.model.ListVirtualMachinesRequest;
import com.amazonaws.services.backupgateway.model.ListVirtualMachinesResult;
import com.amazonaws.services.backupgateway.model.PutMaintenanceStartTimeRequest;
import com.amazonaws.services.backupgateway.model.PutMaintenanceStartTimeResult;
import com.amazonaws.services.backupgateway.model.TagResourceRequest;
import com.amazonaws.services.backupgateway.model.TagResourceResult;
import com.amazonaws.services.backupgateway.model.TestHypervisorConfigurationRequest;
import com.amazonaws.services.backupgateway.model.TestHypervisorConfigurationResult;
import com.amazonaws.services.backupgateway.model.UntagResourceRequest;
import com.amazonaws.services.backupgateway.model.UntagResourceResult;
import com.amazonaws.services.backupgateway.model.UpdateGatewayInformationRequest;
import com.amazonaws.services.backupgateway.model.UpdateGatewayInformationResult;
import com.amazonaws.services.backupgateway.model.UpdateHypervisorRequest;
import com.amazonaws.services.backupgateway.model.UpdateHypervisorResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSBackupGatewayAsyncClient
extends AWSBackupGatewayClient
implements AWSBackupGatewayAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSBackupGatewayAsyncClientBuilder asyncBuilder() {
        return AWSBackupGatewayAsyncClientBuilder.standard();
    }

    AWSBackupGatewayAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSBackupGatewayAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateGatewayToServerResult> associateGatewayToServerAsync(AssociateGatewayToServerRequest request) {
        return this.associateGatewayToServerAsync(request, null);
    }

    @Override
    public Future<AssociateGatewayToServerResult> associateGatewayToServerAsync(AssociateGatewayToServerRequest request, final AsyncHandler<AssociateGatewayToServerRequest, AssociateGatewayToServerResult> asyncHandler) {
        final AssociateGatewayToServerRequest finalRequest = (AssociateGatewayToServerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateGatewayToServerResult>(){

            @Override
            public AssociateGatewayToServerResult call() throws Exception {
                AssociateGatewayToServerResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeAssociateGatewayToServer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGatewayResult> createGatewayAsync(CreateGatewayRequest request) {
        return this.createGatewayAsync(request, null);
    }

    @Override
    public Future<CreateGatewayResult> createGatewayAsync(CreateGatewayRequest request, final AsyncHandler<CreateGatewayRequest, CreateGatewayResult> asyncHandler) {
        final CreateGatewayRequest finalRequest = (CreateGatewayRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGatewayResult>(){

            @Override
            public CreateGatewayResult call() throws Exception {
                CreateGatewayResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeCreateGateway(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGatewayResult> deleteGatewayAsync(DeleteGatewayRequest request) {
        return this.deleteGatewayAsync(request, null);
    }

    @Override
    public Future<DeleteGatewayResult> deleteGatewayAsync(DeleteGatewayRequest request, final AsyncHandler<DeleteGatewayRequest, DeleteGatewayResult> asyncHandler) {
        final DeleteGatewayRequest finalRequest = (DeleteGatewayRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGatewayResult>(){

            @Override
            public DeleteGatewayResult call() throws Exception {
                DeleteGatewayResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeDeleteGateway(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHypervisorResult> deleteHypervisorAsync(DeleteHypervisorRequest request) {
        return this.deleteHypervisorAsync(request, null);
    }

    @Override
    public Future<DeleteHypervisorResult> deleteHypervisorAsync(DeleteHypervisorRequest request, final AsyncHandler<DeleteHypervisorRequest, DeleteHypervisorResult> asyncHandler) {
        final DeleteHypervisorRequest finalRequest = (DeleteHypervisorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteHypervisorResult>(){

            @Override
            public DeleteHypervisorResult call() throws Exception {
                DeleteHypervisorResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeDeleteHypervisor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateGatewayFromServerResult> disassociateGatewayFromServerAsync(DisassociateGatewayFromServerRequest request) {
        return this.disassociateGatewayFromServerAsync(request, null);
    }

    @Override
    public Future<DisassociateGatewayFromServerResult> disassociateGatewayFromServerAsync(DisassociateGatewayFromServerRequest request, final AsyncHandler<DisassociateGatewayFromServerRequest, DisassociateGatewayFromServerResult> asyncHandler) {
        final DisassociateGatewayFromServerRequest finalRequest = (DisassociateGatewayFromServerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateGatewayFromServerResult>(){

            @Override
            public DisassociateGatewayFromServerResult call() throws Exception {
                DisassociateGatewayFromServerResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeDisassociateGatewayFromServer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportHypervisorConfigurationResult> importHypervisorConfigurationAsync(ImportHypervisorConfigurationRequest request) {
        return this.importHypervisorConfigurationAsync(request, null);
    }

    @Override
    public Future<ImportHypervisorConfigurationResult> importHypervisorConfigurationAsync(ImportHypervisorConfigurationRequest request, final AsyncHandler<ImportHypervisorConfigurationRequest, ImportHypervisorConfigurationResult> asyncHandler) {
        final ImportHypervisorConfigurationRequest finalRequest = (ImportHypervisorConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ImportHypervisorConfigurationResult>(){

            @Override
            public ImportHypervisorConfigurationResult call() throws Exception {
                ImportHypervisorConfigurationResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeImportHypervisorConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGatewaysResult> listGatewaysAsync(ListGatewaysRequest request) {
        return this.listGatewaysAsync(request, null);
    }

    @Override
    public Future<ListGatewaysResult> listGatewaysAsync(ListGatewaysRequest request, final AsyncHandler<ListGatewaysRequest, ListGatewaysResult> asyncHandler) {
        final ListGatewaysRequest finalRequest = (ListGatewaysRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGatewaysResult>(){

            @Override
            public ListGatewaysResult call() throws Exception {
                ListGatewaysResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeListGateways(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHypervisorsResult> listHypervisorsAsync(ListHypervisorsRequest request) {
        return this.listHypervisorsAsync(request, null);
    }

    @Override
    public Future<ListHypervisorsResult> listHypervisorsAsync(ListHypervisorsRequest request, final AsyncHandler<ListHypervisorsRequest, ListHypervisorsResult> asyncHandler) {
        final ListHypervisorsRequest finalRequest = (ListHypervisorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListHypervisorsResult>(){

            @Override
            public ListHypervisorsResult call() throws Exception {
                ListHypervisorsResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeListHypervisors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVirtualMachinesResult> listVirtualMachinesAsync(ListVirtualMachinesRequest request) {
        return this.listVirtualMachinesAsync(request, null);
    }

    @Override
    public Future<ListVirtualMachinesResult> listVirtualMachinesAsync(ListVirtualMachinesRequest request, final AsyncHandler<ListVirtualMachinesRequest, ListVirtualMachinesResult> asyncHandler) {
        final ListVirtualMachinesRequest finalRequest = (ListVirtualMachinesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListVirtualMachinesResult>(){

            @Override
            public ListVirtualMachinesResult call() throws Exception {
                ListVirtualMachinesResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeListVirtualMachines(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutMaintenanceStartTimeResult> putMaintenanceStartTimeAsync(PutMaintenanceStartTimeRequest request) {
        return this.putMaintenanceStartTimeAsync(request, null);
    }

    @Override
    public Future<PutMaintenanceStartTimeResult> putMaintenanceStartTimeAsync(PutMaintenanceStartTimeRequest request, final AsyncHandler<PutMaintenanceStartTimeRequest, PutMaintenanceStartTimeResult> asyncHandler) {
        final PutMaintenanceStartTimeRequest finalRequest = (PutMaintenanceStartTimeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutMaintenanceStartTimeResult>(){

            @Override
            public PutMaintenanceStartTimeResult call() throws Exception {
                PutMaintenanceStartTimeResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executePutMaintenanceStartTime(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TestHypervisorConfigurationResult> testHypervisorConfigurationAsync(TestHypervisorConfigurationRequest request) {
        return this.testHypervisorConfigurationAsync(request, null);
    }

    @Override
    public Future<TestHypervisorConfigurationResult> testHypervisorConfigurationAsync(TestHypervisorConfigurationRequest request, final AsyncHandler<TestHypervisorConfigurationRequest, TestHypervisorConfigurationResult> asyncHandler) {
        final TestHypervisorConfigurationRequest finalRequest = (TestHypervisorConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TestHypervisorConfigurationResult>(){

            @Override
            public TestHypervisorConfigurationResult call() throws Exception {
                TestHypervisorConfigurationResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeTestHypervisorConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGatewayInformationResult> updateGatewayInformationAsync(UpdateGatewayInformationRequest request) {
        return this.updateGatewayInformationAsync(request, null);
    }

    @Override
    public Future<UpdateGatewayInformationResult> updateGatewayInformationAsync(UpdateGatewayInformationRequest request, final AsyncHandler<UpdateGatewayInformationRequest, UpdateGatewayInformationResult> asyncHandler) {
        final UpdateGatewayInformationRequest finalRequest = (UpdateGatewayInformationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateGatewayInformationResult>(){

            @Override
            public UpdateGatewayInformationResult call() throws Exception {
                UpdateGatewayInformationResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeUpdateGatewayInformation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateHypervisorResult> updateHypervisorAsync(UpdateHypervisorRequest request) {
        return this.updateHypervisorAsync(request, null);
    }

    @Override
    public Future<UpdateHypervisorResult> updateHypervisorAsync(UpdateHypervisorRequest request, final AsyncHandler<UpdateHypervisorRequest, UpdateHypervisorResult> asyncHandler) {
        final UpdateHypervisorRequest finalRequest = (UpdateHypervisorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateHypervisorResult>(){

            @Override
            public UpdateHypervisorResult call() throws Exception {
                UpdateHypervisorResult result = null;
                try {
                    result = AWSBackupGatewayAsyncClient.this.executeUpdateHypervisor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

