/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backup.model.ProtectedResource;
import java.util.Date;

@SdkInternalApi
public class ProtectedResourceMarshaller {
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").build();
    private static final MarshallingInfo<Date> LASTBACKUPTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastBackupTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceName").build();
    private static final MarshallingInfo<String> LASTBACKUPVAULTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastBackupVaultArn").build();
    private static final MarshallingInfo<String> LASTRECOVERYPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastRecoveryPointArn").build();
    private static final ProtectedResourceMarshaller instance = new ProtectedResourceMarshaller();

    public static ProtectedResourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProtectedResource protectedResource, ProtocolMarshaller protocolMarshaller) {
        if (protectedResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)protectedResource.getResourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)protectedResource.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)protectedResource.getLastBackupTime(), LASTBACKUPTIME_BINDING);
            protocolMarshaller.marshall((Object)protectedResource.getResourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)protectedResource.getLastBackupVaultArn(), LASTBACKUPVAULTARN_BINDING);
            protocolMarshaller.marshall((Object)protectedResource.getLastRecoveryPointArn(), LASTRECOVERYPOINTARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

