/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backup.model.RestoreTestingRecoveryPointSelectionAlgorithm;
import com.amazonaws.services.backup.model.RestoreTestingRecoveryPointType;
import com.amazonaws.services.backup.model.transform.RestoreTestingRecoveryPointSelectionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RestoreTestingRecoveryPointSelection
implements Serializable,
Cloneable,
StructuredPojo {
    private String algorithm;
    private List<String> excludeVaults;
    private List<String> includeVaults;
    private List<String> recoveryPointTypes;
    private Integer selectionWindowDays;

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public RestoreTestingRecoveryPointSelection withAlgorithm(String algorithm) {
        this.setAlgorithm(algorithm);
        return this;
    }

    public RestoreTestingRecoveryPointSelection withAlgorithm(RestoreTestingRecoveryPointSelectionAlgorithm algorithm) {
        this.algorithm = algorithm.toString();
        return this;
    }

    public List<String> getExcludeVaults() {
        return this.excludeVaults;
    }

    public void setExcludeVaults(Collection<String> excludeVaults) {
        if (excludeVaults == null) {
            this.excludeVaults = null;
            return;
        }
        this.excludeVaults = new ArrayList<String>(excludeVaults);
    }

    public RestoreTestingRecoveryPointSelection withExcludeVaults(String ... excludeVaults) {
        if (this.excludeVaults == null) {
            this.setExcludeVaults(new ArrayList<String>(excludeVaults.length));
        }
        for (String ele : excludeVaults) {
            this.excludeVaults.add(ele);
        }
        return this;
    }

    public RestoreTestingRecoveryPointSelection withExcludeVaults(Collection<String> excludeVaults) {
        this.setExcludeVaults(excludeVaults);
        return this;
    }

    public List<String> getIncludeVaults() {
        return this.includeVaults;
    }

    public void setIncludeVaults(Collection<String> includeVaults) {
        if (includeVaults == null) {
            this.includeVaults = null;
            return;
        }
        this.includeVaults = new ArrayList<String>(includeVaults);
    }

    public RestoreTestingRecoveryPointSelection withIncludeVaults(String ... includeVaults) {
        if (this.includeVaults == null) {
            this.setIncludeVaults(new ArrayList<String>(includeVaults.length));
        }
        for (String ele : includeVaults) {
            this.includeVaults.add(ele);
        }
        return this;
    }

    public RestoreTestingRecoveryPointSelection withIncludeVaults(Collection<String> includeVaults) {
        this.setIncludeVaults(includeVaults);
        return this;
    }

    public List<String> getRecoveryPointTypes() {
        return this.recoveryPointTypes;
    }

    public void setRecoveryPointTypes(Collection<String> recoveryPointTypes) {
        if (recoveryPointTypes == null) {
            this.recoveryPointTypes = null;
            return;
        }
        this.recoveryPointTypes = new ArrayList<String>(recoveryPointTypes);
    }

    public RestoreTestingRecoveryPointSelection withRecoveryPointTypes(String ... recoveryPointTypes) {
        if (this.recoveryPointTypes == null) {
            this.setRecoveryPointTypes(new ArrayList<String>(recoveryPointTypes.length));
        }
        for (String ele : recoveryPointTypes) {
            this.recoveryPointTypes.add(ele);
        }
        return this;
    }

    public RestoreTestingRecoveryPointSelection withRecoveryPointTypes(Collection<String> recoveryPointTypes) {
        this.setRecoveryPointTypes(recoveryPointTypes);
        return this;
    }

    public RestoreTestingRecoveryPointSelection withRecoveryPointTypes(RestoreTestingRecoveryPointType ... recoveryPointTypes) {
        ArrayList<String> recoveryPointTypesCopy = new ArrayList<String>(recoveryPointTypes.length);
        for (RestoreTestingRecoveryPointType value : recoveryPointTypes) {
            recoveryPointTypesCopy.add(value.toString());
        }
        if (this.getRecoveryPointTypes() == null) {
            this.setRecoveryPointTypes(recoveryPointTypesCopy);
        } else {
            this.getRecoveryPointTypes().addAll(recoveryPointTypesCopy);
        }
        return this;
    }

    public void setSelectionWindowDays(Integer selectionWindowDays) {
        this.selectionWindowDays = selectionWindowDays;
    }

    public Integer getSelectionWindowDays() {
        return this.selectionWindowDays;
    }

    public RestoreTestingRecoveryPointSelection withSelectionWindowDays(Integer selectionWindowDays) {
        this.setSelectionWindowDays(selectionWindowDays);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlgorithm() != null) {
            sb.append("Algorithm: ").append(this.getAlgorithm()).append(",");
        }
        if (this.getExcludeVaults() != null) {
            sb.append("ExcludeVaults: ").append(this.getExcludeVaults()).append(",");
        }
        if (this.getIncludeVaults() != null) {
            sb.append("IncludeVaults: ").append(this.getIncludeVaults()).append(",");
        }
        if (this.getRecoveryPointTypes() != null) {
            sb.append("RecoveryPointTypes: ").append(this.getRecoveryPointTypes()).append(",");
        }
        if (this.getSelectionWindowDays() != null) {
            sb.append("SelectionWindowDays: ").append(this.getSelectionWindowDays());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTestingRecoveryPointSelection)) {
            return false;
        }
        RestoreTestingRecoveryPointSelection other = (RestoreTestingRecoveryPointSelection)obj;
        if (other.getAlgorithm() == null ^ this.getAlgorithm() == null) {
            return false;
        }
        if (other.getAlgorithm() != null && !other.getAlgorithm().equals(this.getAlgorithm())) {
            return false;
        }
        if (other.getExcludeVaults() == null ^ this.getExcludeVaults() == null) {
            return false;
        }
        if (other.getExcludeVaults() != null && !other.getExcludeVaults().equals(this.getExcludeVaults())) {
            return false;
        }
        if (other.getIncludeVaults() == null ^ this.getIncludeVaults() == null) {
            return false;
        }
        if (other.getIncludeVaults() != null && !other.getIncludeVaults().equals(this.getIncludeVaults())) {
            return false;
        }
        if (other.getRecoveryPointTypes() == null ^ this.getRecoveryPointTypes() == null) {
            return false;
        }
        if (other.getRecoveryPointTypes() != null && !other.getRecoveryPointTypes().equals(this.getRecoveryPointTypes())) {
            return false;
        }
        if (other.getSelectionWindowDays() == null ^ this.getSelectionWindowDays() == null) {
            return false;
        }
        return other.getSelectionWindowDays() == null || other.getSelectionWindowDays().equals(this.getSelectionWindowDays());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlgorithm() == null ? 0 : this.getAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeVaults() == null ? 0 : this.getExcludeVaults().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeVaults() == null ? 0 : this.getIncludeVaults().hashCode());
        hashCode = 31 * hashCode + (this.getRecoveryPointTypes() == null ? 0 : this.getRecoveryPointTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSelectionWindowDays() == null ? 0 : this.getSelectionWindowDays().hashCode());
        return hashCode;
    }

    public RestoreTestingRecoveryPointSelection clone() {
        try {
            return (RestoreTestingRecoveryPointSelection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RestoreTestingRecoveryPointSelectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

