/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backup.model.transform.ControlScopeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ControlScope
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> complianceResourceIds;
    private List<String> complianceResourceTypes;
    private Map<String, String> tags;

    public List<String> getComplianceResourceIds() {
        return this.complianceResourceIds;
    }

    public void setComplianceResourceIds(Collection<String> complianceResourceIds) {
        if (complianceResourceIds == null) {
            this.complianceResourceIds = null;
            return;
        }
        this.complianceResourceIds = new ArrayList<String>(complianceResourceIds);
    }

    public ControlScope withComplianceResourceIds(String ... complianceResourceIds) {
        if (this.complianceResourceIds == null) {
            this.setComplianceResourceIds(new ArrayList<String>(complianceResourceIds.length));
        }
        for (String ele : complianceResourceIds) {
            this.complianceResourceIds.add(ele);
        }
        return this;
    }

    public ControlScope withComplianceResourceIds(Collection<String> complianceResourceIds) {
        this.setComplianceResourceIds(complianceResourceIds);
        return this;
    }

    public List<String> getComplianceResourceTypes() {
        return this.complianceResourceTypes;
    }

    public void setComplianceResourceTypes(Collection<String> complianceResourceTypes) {
        if (complianceResourceTypes == null) {
            this.complianceResourceTypes = null;
            return;
        }
        this.complianceResourceTypes = new ArrayList<String>(complianceResourceTypes);
    }

    public ControlScope withComplianceResourceTypes(String ... complianceResourceTypes) {
        if (this.complianceResourceTypes == null) {
            this.setComplianceResourceTypes(new ArrayList<String>(complianceResourceTypes.length));
        }
        for (String ele : complianceResourceTypes) {
            this.complianceResourceTypes.add(ele);
        }
        return this;
    }

    public ControlScope withComplianceResourceTypes(Collection<String> complianceResourceTypes) {
        this.setComplianceResourceTypes(complianceResourceTypes);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public ControlScope withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public ControlScope addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public ControlScope clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComplianceResourceIds() != null) {
            sb.append("ComplianceResourceIds: ").append(this.getComplianceResourceIds()).append(",");
        }
        if (this.getComplianceResourceTypes() != null) {
            sb.append("ComplianceResourceTypes: ").append(this.getComplianceResourceTypes()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlScope)) {
            return false;
        }
        ControlScope other = (ControlScope)obj;
        if (other.getComplianceResourceIds() == null ^ this.getComplianceResourceIds() == null) {
            return false;
        }
        if (other.getComplianceResourceIds() != null && !other.getComplianceResourceIds().equals(this.getComplianceResourceIds())) {
            return false;
        }
        if (other.getComplianceResourceTypes() == null ^ this.getComplianceResourceTypes() == null) {
            return false;
        }
        if (other.getComplianceResourceTypes() != null && !other.getComplianceResourceTypes().equals(this.getComplianceResourceTypes())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComplianceResourceIds() == null ? 0 : this.getComplianceResourceIds().hashCode());
        hashCode = 31 * hashCode + (this.getComplianceResourceTypes() == null ? 0 : this.getComplianceResourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ControlScope clone() {
        try {
            return (ControlScope)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ControlScopeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

