/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backup.model.ControlInputParameter;
import com.amazonaws.services.backup.model.ControlScope;
import com.amazonaws.services.backup.model.transform.FrameworkControlMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FrameworkControl
implements Serializable,
Cloneable,
StructuredPojo {
    private String controlName;
    private List<ControlInputParameter> controlInputParameters;
    private ControlScope controlScope;

    public void setControlName(String controlName) {
        this.controlName = controlName;
    }

    public String getControlName() {
        return this.controlName;
    }

    public FrameworkControl withControlName(String controlName) {
        this.setControlName(controlName);
        return this;
    }

    public List<ControlInputParameter> getControlInputParameters() {
        return this.controlInputParameters;
    }

    public void setControlInputParameters(Collection<ControlInputParameter> controlInputParameters) {
        if (controlInputParameters == null) {
            this.controlInputParameters = null;
            return;
        }
        this.controlInputParameters = new ArrayList<ControlInputParameter>(controlInputParameters);
    }

    public FrameworkControl withControlInputParameters(ControlInputParameter ... controlInputParameters) {
        if (this.controlInputParameters == null) {
            this.setControlInputParameters(new ArrayList<ControlInputParameter>(controlInputParameters.length));
        }
        for (ControlInputParameter ele : controlInputParameters) {
            this.controlInputParameters.add(ele);
        }
        return this;
    }

    public FrameworkControl withControlInputParameters(Collection<ControlInputParameter> controlInputParameters) {
        this.setControlInputParameters(controlInputParameters);
        return this;
    }

    public void setControlScope(ControlScope controlScope) {
        this.controlScope = controlScope;
    }

    public ControlScope getControlScope() {
        return this.controlScope;
    }

    public FrameworkControl withControlScope(ControlScope controlScope) {
        this.setControlScope(controlScope);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getControlName() != null) {
            sb.append("ControlName: ").append(this.getControlName()).append(",");
        }
        if (this.getControlInputParameters() != null) {
            sb.append("ControlInputParameters: ").append(this.getControlInputParameters()).append(",");
        }
        if (this.getControlScope() != null) {
            sb.append("ControlScope: ").append(this.getControlScope());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameworkControl)) {
            return false;
        }
        FrameworkControl other = (FrameworkControl)obj;
        if (other.getControlName() == null ^ this.getControlName() == null) {
            return false;
        }
        if (other.getControlName() != null && !other.getControlName().equals(this.getControlName())) {
            return false;
        }
        if (other.getControlInputParameters() == null ^ this.getControlInputParameters() == null) {
            return false;
        }
        if (other.getControlInputParameters() != null && !other.getControlInputParameters().equals(this.getControlInputParameters())) {
            return false;
        }
        if (other.getControlScope() == null ^ this.getControlScope() == null) {
            return false;
        }
        return other.getControlScope() == null || other.getControlScope().equals(this.getControlScope());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getControlName() == null ? 0 : this.getControlName().hashCode());
        hashCode = 31 * hashCode + (this.getControlInputParameters() == null ? 0 : this.getControlInputParameters().hashCode());
        hashCode = 31 * hashCode + (this.getControlScope() == null ? 0 : this.getControlScope().hashCode());
        return hashCode;
    }

    public FrameworkControl clone() {
        try {
            return (FrameworkControl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FrameworkControlMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

