/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.backup.model.FrameworkControl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateFrameworkRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String frameworkName;
    private String frameworkDescription;
    private List<FrameworkControl> frameworkControls;
    private String idempotencyToken;
    private Map<String, String> frameworkTags;

    public void setFrameworkName(String frameworkName) {
        this.frameworkName = frameworkName;
    }

    public String getFrameworkName() {
        return this.frameworkName;
    }

    public CreateFrameworkRequest withFrameworkName(String frameworkName) {
        this.setFrameworkName(frameworkName);
        return this;
    }

    public void setFrameworkDescription(String frameworkDescription) {
        this.frameworkDescription = frameworkDescription;
    }

    public String getFrameworkDescription() {
        return this.frameworkDescription;
    }

    public CreateFrameworkRequest withFrameworkDescription(String frameworkDescription) {
        this.setFrameworkDescription(frameworkDescription);
        return this;
    }

    public List<FrameworkControl> getFrameworkControls() {
        return this.frameworkControls;
    }

    public void setFrameworkControls(Collection<FrameworkControl> frameworkControls) {
        if (frameworkControls == null) {
            this.frameworkControls = null;
            return;
        }
        this.frameworkControls = new ArrayList<FrameworkControl>(frameworkControls);
    }

    public CreateFrameworkRequest withFrameworkControls(FrameworkControl ... frameworkControls) {
        if (this.frameworkControls == null) {
            this.setFrameworkControls(new ArrayList<FrameworkControl>(frameworkControls.length));
        }
        for (FrameworkControl ele : frameworkControls) {
            this.frameworkControls.add(ele);
        }
        return this;
    }

    public CreateFrameworkRequest withFrameworkControls(Collection<FrameworkControl> frameworkControls) {
        this.setFrameworkControls(frameworkControls);
        return this;
    }

    public void setIdempotencyToken(String idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public String getIdempotencyToken() {
        return this.idempotencyToken;
    }

    public CreateFrameworkRequest withIdempotencyToken(String idempotencyToken) {
        this.setIdempotencyToken(idempotencyToken);
        return this;
    }

    public Map<String, String> getFrameworkTags() {
        return this.frameworkTags;
    }

    public void setFrameworkTags(Map<String, String> frameworkTags) {
        this.frameworkTags = frameworkTags;
    }

    public CreateFrameworkRequest withFrameworkTags(Map<String, String> frameworkTags) {
        this.setFrameworkTags(frameworkTags);
        return this;
    }

    public CreateFrameworkRequest addFrameworkTagsEntry(String key, String value) {
        if (null == this.frameworkTags) {
            this.frameworkTags = new HashMap<String, String>();
        }
        if (this.frameworkTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.frameworkTags.put(key, value);
        return this;
    }

    public CreateFrameworkRequest clearFrameworkTagsEntries() {
        this.frameworkTags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFrameworkName() != null) {
            sb.append("FrameworkName: ").append(this.getFrameworkName()).append(",");
        }
        if (this.getFrameworkDescription() != null) {
            sb.append("FrameworkDescription: ").append(this.getFrameworkDescription()).append(",");
        }
        if (this.getFrameworkControls() != null) {
            sb.append("FrameworkControls: ").append(this.getFrameworkControls()).append(",");
        }
        if (this.getIdempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.getIdempotencyToken()).append(",");
        }
        if (this.getFrameworkTags() != null) {
            sb.append("FrameworkTags: ").append(this.getFrameworkTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFrameworkRequest)) {
            return false;
        }
        CreateFrameworkRequest other = (CreateFrameworkRequest)obj;
        if (other.getFrameworkName() == null ^ this.getFrameworkName() == null) {
            return false;
        }
        if (other.getFrameworkName() != null && !other.getFrameworkName().equals(this.getFrameworkName())) {
            return false;
        }
        if (other.getFrameworkDescription() == null ^ this.getFrameworkDescription() == null) {
            return false;
        }
        if (other.getFrameworkDescription() != null && !other.getFrameworkDescription().equals(this.getFrameworkDescription())) {
            return false;
        }
        if (other.getFrameworkControls() == null ^ this.getFrameworkControls() == null) {
            return false;
        }
        if (other.getFrameworkControls() != null && !other.getFrameworkControls().equals(this.getFrameworkControls())) {
            return false;
        }
        if (other.getIdempotencyToken() == null ^ this.getIdempotencyToken() == null) {
            return false;
        }
        if (other.getIdempotencyToken() != null && !other.getIdempotencyToken().equals(this.getIdempotencyToken())) {
            return false;
        }
        if (other.getFrameworkTags() == null ^ this.getFrameworkTags() == null) {
            return false;
        }
        return other.getFrameworkTags() == null || other.getFrameworkTags().equals(this.getFrameworkTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFrameworkName() == null ? 0 : this.getFrameworkName().hashCode());
        hashCode = 31 * hashCode + (this.getFrameworkDescription() == null ? 0 : this.getFrameworkDescription().hashCode());
        hashCode = 31 * hashCode + (this.getFrameworkControls() == null ? 0 : this.getFrameworkControls().hashCode());
        hashCode = 31 * hashCode + (this.getIdempotencyToken() == null ? 0 : this.getIdempotencyToken().hashCode());
        hashCode = 31 * hashCode + (this.getFrameworkTags() == null ? 0 : this.getFrameworkTags().hashCode());
        return hashCode;
    }

    public CreateFrameworkRequest clone() {
        return (CreateFrameworkRequest)super.clone();
    }
}

