/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backup.model.AdvancedBackupSetting;
import com.amazonaws.services.backup.model.BackupRuleInput;
import com.amazonaws.services.backup.model.transform.BackupPlanInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BackupPlanInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String backupPlanName;
    private List<BackupRuleInput> rules;
    private List<AdvancedBackupSetting> advancedBackupSettings;

    public void setBackupPlanName(String backupPlanName) {
        this.backupPlanName = backupPlanName;
    }

    public String getBackupPlanName() {
        return this.backupPlanName;
    }

    public BackupPlanInput withBackupPlanName(String backupPlanName) {
        this.setBackupPlanName(backupPlanName);
        return this;
    }

    public List<BackupRuleInput> getRules() {
        return this.rules;
    }

    public void setRules(Collection<BackupRuleInput> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<BackupRuleInput>(rules);
    }

    public BackupPlanInput withRules(BackupRuleInput ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<BackupRuleInput>(rules.length));
        }
        for (BackupRuleInput ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public BackupPlanInput withRules(Collection<BackupRuleInput> rules) {
        this.setRules(rules);
        return this;
    }

    public List<AdvancedBackupSetting> getAdvancedBackupSettings() {
        return this.advancedBackupSettings;
    }

    public void setAdvancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings) {
        if (advancedBackupSettings == null) {
            this.advancedBackupSettings = null;
            return;
        }
        this.advancedBackupSettings = new ArrayList<AdvancedBackupSetting>(advancedBackupSettings);
    }

    public BackupPlanInput withAdvancedBackupSettings(AdvancedBackupSetting ... advancedBackupSettings) {
        if (this.advancedBackupSettings == null) {
            this.setAdvancedBackupSettings(new ArrayList<AdvancedBackupSetting>(advancedBackupSettings.length));
        }
        for (AdvancedBackupSetting ele : advancedBackupSettings) {
            this.advancedBackupSettings.add(ele);
        }
        return this;
    }

    public BackupPlanInput withAdvancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings) {
        this.setAdvancedBackupSettings(advancedBackupSettings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBackupPlanName() != null) {
            sb.append("BackupPlanName: ").append(this.getBackupPlanName()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules()).append(",");
        }
        if (this.getAdvancedBackupSettings() != null) {
            sb.append("AdvancedBackupSettings: ").append(this.getAdvancedBackupSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupPlanInput)) {
            return false;
        }
        BackupPlanInput other = (BackupPlanInput)obj;
        if (other.getBackupPlanName() == null ^ this.getBackupPlanName() == null) {
            return false;
        }
        if (other.getBackupPlanName() != null && !other.getBackupPlanName().equals(this.getBackupPlanName())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        if (other.getRules() != null && !other.getRules().equals(this.getRules())) {
            return false;
        }
        if (other.getAdvancedBackupSettings() == null ^ this.getAdvancedBackupSettings() == null) {
            return false;
        }
        return other.getAdvancedBackupSettings() == null || other.getAdvancedBackupSettings().equals(this.getAdvancedBackupSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBackupPlanName() == null ? 0 : this.getBackupPlanName().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        hashCode = 31 * hashCode + (this.getAdvancedBackupSettings() == null ? 0 : this.getAdvancedBackupSettings().hashCode());
        return hashCode;
    }

    public BackupPlanInput clone() {
        try {
            return (BackupPlanInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackupPlanInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

