/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backup.model.Framework;
import java.util.Date;

@SdkInternalApi
public class FrameworkMarshaller {
    private static final MarshallingInfo<String> FRAMEWORKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameworkName").build();
    private static final MarshallingInfo<String> FRAMEWORKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameworkArn").build();
    private static final MarshallingInfo<String> FRAMEWORKDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameworkDescription").build();
    private static final MarshallingInfo<Integer> NUMBEROFCONTROLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfControls").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> DEPLOYMENTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeploymentStatus").build();
    private static final FrameworkMarshaller instance = new FrameworkMarshaller();

    public static FrameworkMarshaller getInstance() {
        return instance;
    }

    public void marshall(Framework framework, ProtocolMarshaller protocolMarshaller) {
        if (framework == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)framework.getFrameworkName(), FRAMEWORKNAME_BINDING);
            protocolMarshaller.marshall((Object)framework.getFrameworkArn(), FRAMEWORKARN_BINDING);
            protocolMarshaller.marshall((Object)framework.getFrameworkDescription(), FRAMEWORKDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)framework.getNumberOfControls(), NUMBEROFCONTROLS_BINDING);
            protocolMarshaller.marshall((Object)framework.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)framework.getDeploymentStatus(), DEPLOYMENTSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

